package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SqlConfiguration(
    queryIdentifiersEnclosingOption: Optional[
      zio.aws.kendra.model.QueryIdentifiersEnclosingOption
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SqlConfiguration = {
    import SqlConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SqlConfiguration
      .builder()
      .optionallyWith(
        queryIdentifiersEnclosingOption.map(value => value.unwrap)
      )(_.queryIdentifiersEnclosingOption)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SqlConfiguration.ReadOnly =
    zio.aws.kendra.model.SqlConfiguration.wrap(buildAwsValue())
}
object SqlConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SqlConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SqlConfiguration = zio.aws.kendra.model
      .SqlConfiguration(queryIdentifiersEnclosingOption.map(value => value))
    def queryIdentifiersEnclosingOption
        : Optional[zio.aws.kendra.model.QueryIdentifiersEnclosingOption]
    def getQueryIdentifiersEnclosingOption: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.QueryIdentifiersEnclosingOption
    ] = AwsError.unwrapOptionField(
      "queryIdentifiersEnclosingOption",
      queryIdentifiersEnclosingOption
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SqlConfiguration
  ) extends zio.aws.kendra.model.SqlConfiguration.ReadOnly {
    override val queryIdentifiersEnclosingOption
        : Optional[zio.aws.kendra.model.QueryIdentifiersEnclosingOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryIdentifiersEnclosingOption())
        .map(value =>
          zio.aws.kendra.model.QueryIdentifiersEnclosingOption.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SqlConfiguration
  ): zio.aws.kendra.model.SqlConfiguration.ReadOnly = new Wrapper(impl)
}
