package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{IndexId, DataSourceId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartDataSourceSyncJobRequest(
    id: DataSourceId,
    indexId: IndexId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobRequest = {
    import StartDataSourceSyncJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobRequest
      .builder()
      .id(DataSourceId.unwrap(id): java.lang.String)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.StartDataSourceSyncJobRequest.ReadOnly =
    zio.aws.kendra.model.StartDataSourceSyncJobRequest.wrap(buildAwsValue())
}
object StartDataSourceSyncJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.StartDataSourceSyncJobRequest =
      zio.aws.kendra.model.StartDataSourceSyncJobRequest(id, indexId)
    def id: DataSourceId
    def indexId: IndexId
    def getId: ZIO[Any, Nothing, DataSourceId] = ZIO.succeed(id)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobRequest
  ) extends zio.aws.kendra.model.StartDataSourceSyncJobRequest.ReadOnly {
    override val id: DataSourceId =
      zio.aws.kendra.model.primitives.DataSourceId(impl.id())
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobRequest
  ): zio.aws.kendra.model.StartDataSourceSyncJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
