package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{QueryId, IndexId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SubmitFeedbackRequest(
    indexId: IndexId,
    queryId: QueryId,
    clickFeedbackItems: Optional[Iterable[zio.aws.kendra.model.ClickFeedback]] =
      Optional.Absent,
    relevanceFeedbackItems: Optional[
      Iterable[zio.aws.kendra.model.RelevanceFeedback]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SubmitFeedbackRequest = {
    import SubmitFeedbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SubmitFeedbackRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .queryId(QueryId.unwrap(queryId): java.lang.String)
      .optionallyWith(
        clickFeedbackItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clickFeedbackItems)
      .optionallyWith(
        relevanceFeedbackItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relevanceFeedbackItems)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SubmitFeedbackRequest.ReadOnly =
    zio.aws.kendra.model.SubmitFeedbackRequest.wrap(buildAwsValue())
}
object SubmitFeedbackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SubmitFeedbackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SubmitFeedbackRequest =
      zio.aws.kendra.model.SubmitFeedbackRequest(
        indexId,
        queryId,
        clickFeedbackItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relevanceFeedbackItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def indexId: IndexId
    def queryId: QueryId
    def clickFeedbackItems
        : Optional[List[zio.aws.kendra.model.ClickFeedback.ReadOnly]]
    def relevanceFeedbackItems
        : Optional[List[zio.aws.kendra.model.RelevanceFeedback.ReadOnly]]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getQueryId: ZIO[Any, Nothing, QueryId] = ZIO.succeed(queryId)
    def getClickFeedbackItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.ClickFeedback.ReadOnly
    ]] = AwsError.unwrapOptionField("clickFeedbackItems", clickFeedbackItems)
    def getRelevanceFeedbackItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.RelevanceFeedback.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "relevanceFeedbackItems",
      relevanceFeedbackItems
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SubmitFeedbackRequest
  ) extends zio.aws.kendra.model.SubmitFeedbackRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val queryId: QueryId =
      zio.aws.kendra.model.primitives.QueryId(impl.queryId())
    override val clickFeedbackItems
        : Optional[List[zio.aws.kendra.model.ClickFeedback.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clickFeedbackItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.ClickFeedback.wrap(item)
          }.toList
        )
    override val relevanceFeedbackItems
        : Optional[List[zio.aws.kendra.model.RelevanceFeedback.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relevanceFeedbackItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.RelevanceFeedback.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SubmitFeedbackRequest
  ): zio.aws.kendra.model.SubmitFeedbackRequest.ReadOnly = new Wrapper(impl)
}
