package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.ResultId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Suggestion(
    id: Optional[ResultId] = Optional.Absent,
    value: Optional[zio.aws.kendra.model.SuggestionValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.Suggestion = {
    import Suggestion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Suggestion
      .builder()
      .optionallyWith(
        id.map(value => ResultId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Suggestion.ReadOnly =
    zio.aws.kendra.model.Suggestion.wrap(buildAwsValue())
}
object Suggestion {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Suggestion] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Suggestion = zio.aws.kendra.model
      .Suggestion(id.map(value => value), value.map(value => value.asEditable))
    def id: Optional[ResultId]
    def value: Optional[zio.aws.kendra.model.SuggestionValue.ReadOnly]
    def getId: ZIO[Any, AwsError, ResultId] =
      AwsError.unwrapOptionField("id", id)
    def getValue
        : ZIO[Any, AwsError, zio.aws.kendra.model.SuggestionValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Suggestion
  ) extends zio.aws.kendra.model.Suggestion.ReadOnly {
    override val id: Optional[ResultId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ResultId(value))
    override val value
        : Optional[zio.aws.kendra.model.SuggestionValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value => zio.aws.kendra.model.SuggestionValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Suggestion
  ): zio.aws.kendra.model.Suggestion.ReadOnly = new Wrapper(impl)
}
