package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SuggestionHighlight(
    beginOffset: Optional[Integer] = Optional.Absent,
    endOffset: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SuggestionHighlight = {
    import SuggestionHighlight.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SuggestionHighlight
      .builder()
      .optionallyWith(beginOffset.map(value => value: java.lang.Integer))(
        _.beginOffset
      )
      .optionallyWith(endOffset.map(value => value: java.lang.Integer))(
        _.endOffset
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SuggestionHighlight.ReadOnly =
    zio.aws.kendra.model.SuggestionHighlight.wrap(buildAwsValue())
}
object SuggestionHighlight {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SuggestionHighlight
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SuggestionHighlight =
      zio.aws.kendra.model.SuggestionHighlight(
        beginOffset.map(value => value),
        endOffset.map(value => value)
      )
    def beginOffset: Optional[Integer]
    def endOffset: Optional[Integer]
    def getBeginOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("beginOffset", beginOffset)
    def getEndOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endOffset", endOffset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SuggestionHighlight
  ) extends zio.aws.kendra.model.SuggestionHighlight.ReadOnly {
    override val beginOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.beginOffset())
      .map(value => value: Integer)
    override val endOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.endOffset())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SuggestionHighlight
  ): zio.aws.kendra.model.SuggestionHighlight.ReadOnly = new Wrapper(impl)
}
