package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TableExcerpt(
    rows: Optional[Iterable[zio.aws.kendra.model.TableRow]] = Optional.Absent,
    totalNumberOfRows: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.TableExcerpt = {
    import TableExcerpt.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.TableExcerpt
      .builder()
      .optionallyWith(
        rows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rows)
      .optionallyWith(totalNumberOfRows.map(value => value: java.lang.Integer))(
        _.totalNumberOfRows
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.TableExcerpt.ReadOnly =
    zio.aws.kendra.model.TableExcerpt.wrap(buildAwsValue())
}
object TableExcerpt {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.TableExcerpt
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.TableExcerpt =
      zio.aws.kendra.model.TableExcerpt(
        rows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalNumberOfRows.map(value => value)
      )
    def rows: Optional[List[zio.aws.kendra.model.TableRow.ReadOnly]]
    def totalNumberOfRows: Optional[Integer]
    def getRows
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.TableRow.ReadOnly]] =
      AwsError.unwrapOptionField("rows", rows)
    def getTotalNumberOfRows: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalNumberOfRows", totalNumberOfRows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.TableExcerpt
  ) extends zio.aws.kendra.model.TableExcerpt.ReadOnly {
    override val rows: Optional[List[zio.aws.kendra.model.TableRow.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rows())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.TableRow.wrap(item)
          }.toList
        )
    override val totalNumberOfRows: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalNumberOfRows())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.TableExcerpt
  ): zio.aws.kendra.model.TableExcerpt.ReadOnly = new Wrapper(impl)
}
