package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TableRow(
    cells: Optional[Iterable[zio.aws.kendra.model.TableCell]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kendra.model.TableRow = {
    import TableRow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.TableRow
      .builder()
      .optionallyWith(
        cells.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cells)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.TableRow.ReadOnly =
    zio.aws.kendra.model.TableRow.wrap(buildAwsValue())
}
object TableRow {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.TableRow] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.TableRow =
      zio.aws.kendra.model.TableRow(
        cells.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cells: Optional[List[zio.aws.kendra.model.TableCell.ReadOnly]]
    def getCells
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.TableCell.ReadOnly]] =
      AwsError.unwrapOptionField("cells", cells)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.TableRow
  ) extends zio.aws.kendra.model.TableRow.ReadOnly {
    override val cells
        : Optional[List[zio.aws.kendra.model.TableCell.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cells())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.TableCell.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.TableRow
  ): zio.aws.kendra.model.TableRow.ReadOnly = new Wrapper(impl)
}
