package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.AmazonResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceARN: AmazonResourceName,
    tags: Iterable[zio.aws.kendra.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.TagResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.TagResourceRequest.ReadOnly =
    zio.aws.kendra.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.TagResourceRequest =
      zio.aws.kendra.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: AmazonResourceName
    def tags: List[zio.aws.kendra.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getTags: ZIO[Any, Nothing, List[zio.aws.kendra.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.TagResourceRequest
  ) extends zio.aws.kendra.model.TagResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.kendra.model.primitives.AmazonResourceName(impl.resourceARN())
    override val tags: List[zio.aws.kendra.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.kendra.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.TagResourceRequest
  ): zio.aws.kendra.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
