package zio.aws.kendra.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{Timestamp, ThesaurusName, ThesaurusId}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ThesaurusSummary(
    id: Optional[ThesaurusId] = Optional.Absent,
    name: Optional[ThesaurusName] = Optional.Absent,
    status: Optional[zio.aws.kendra.model.ThesaurusStatus] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ThesaurusSummary = {
    import ThesaurusSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ThesaurusSummary
      .builder()
      .optionallyWith(
        id.map(value => ThesaurusId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ThesaurusName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ThesaurusSummary.ReadOnly =
    zio.aws.kendra.model.ThesaurusSummary.wrap(buildAwsValue())
}
object ThesaurusSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ThesaurusSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ThesaurusSummary =
      zio.aws.kendra.model.ThesaurusSummary(
        id.map(value => value),
        name.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value)
      )
    def id: Optional[ThesaurusId]
    def name: Optional[ThesaurusName]
    def status: Optional[zio.aws.kendra.model.ThesaurusStatus]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def getId: ZIO[Any, AwsError, ThesaurusId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ThesaurusName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.ThesaurusStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ThesaurusSummary
  ) extends zio.aws.kendra.model.ThesaurusSummary.ReadOnly {
    override val id: Optional[ThesaurusId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ThesaurusId(value))
    override val name: Optional[ThesaurusName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.kendra.model.primitives.ThesaurusName(value))
    override val status: Optional[zio.aws.kendra.model.ThesaurusStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kendra.model.ThesaurusStatus.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ThesaurusSummary
  ): zio.aws.kendra.model.ThesaurusSummary.ReadOnly = new Wrapper(impl)
}
