package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ExperienceName,
  ExperienceId,
  RoleArn,
  IndexId,
  Description
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateExperienceRequest(
    id: ExperienceId,
    name: Optional[ExperienceName] = Optional.Absent,
    indexId: IndexId,
    roleArn: Optional[RoleArn] = Optional.Absent,
    configuration: Optional[zio.aws.kendra.model.ExperienceConfiguration] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UpdateExperienceRequest = {
    import UpdateExperienceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UpdateExperienceRequest
      .builder()
      .id(ExperienceId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => ExperienceName.unwrap(value): java.lang.String)
      )(_.name)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.UpdateExperienceRequest.ReadOnly =
    zio.aws.kendra.model.UpdateExperienceRequest.wrap(buildAwsValue())
}
object UpdateExperienceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UpdateExperienceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UpdateExperienceRequest =
      zio.aws.kendra.model.UpdateExperienceRequest(
        id,
        name.map(value => value),
        indexId,
        roleArn.map(value => value),
        configuration.map(value => value.asEditable),
        description.map(value => value)
      )
    def id: ExperienceId
    def name: Optional[ExperienceName]
    def indexId: IndexId
    def roleArn: Optional[RoleArn]
    def configuration
        : Optional[zio.aws.kendra.model.ExperienceConfiguration.ReadOnly]
    def description: Optional[Description]
    def getId: ZIO[Any, Nothing, ExperienceId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, ExperienceName] =
      AwsError.unwrapOptionField("name", name)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ExperienceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UpdateExperienceRequest
  ) extends zio.aws.kendra.model.UpdateExperienceRequest.ReadOnly {
    override val id: ExperienceId =
      zio.aws.kendra.model.primitives.ExperienceId(impl.id())
    override val name: Optional[ExperienceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.kendra.model.primitives.ExperienceName(value))
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val configuration
        : Optional[zio.aws.kendra.model.ExperienceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value => zio.aws.kendra.model.ExperienceConfiguration.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UpdateExperienceRequest
  ): zio.aws.kendra.model.UpdateExperienceRequest.ReadOnly = new Wrapper(impl)
}
