package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  MinimumQueryCount,
  ObjectBoolean,
  IndexId,
  MinimumNumberOfQueryingUsers,
  Integer
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateQuerySuggestionsConfigRequest(
    indexId: IndexId,
    mode: Optional[zio.aws.kendra.model.Mode] = Optional.Absent,
    queryLogLookBackWindowInDays: Optional[Integer] = Optional.Absent,
    includeQueriesWithoutUserInformation: Optional[ObjectBoolean] =
      Optional.Absent,
    minimumNumberOfQueryingUsers: Optional[MinimumNumberOfQueryingUsers] =
      Optional.Absent,
    minimumQueryCount: Optional[MinimumQueryCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsConfigRequest = {
    import UpdateQuerySuggestionsConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsConfigRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        queryLogLookBackWindowInDays.map(value => value: java.lang.Integer)
      )(_.queryLogLookBackWindowInDays)
      .optionallyWith(
        includeQueriesWithoutUserInformation.map(value =>
          ObjectBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.includeQueriesWithoutUserInformation)
      .optionallyWith(
        minimumNumberOfQueryingUsers.map(value =>
          MinimumNumberOfQueryingUsers.unwrap(value): java.lang.Integer
        )
      )(_.minimumNumberOfQueryingUsers)
      .optionallyWith(
        minimumQueryCount.map(value =>
          MinimumQueryCount.unwrap(value): java.lang.Integer
        )
      )(_.minimumQueryCount)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.UpdateQuerySuggestionsConfigRequest.ReadOnly =
    zio.aws.kendra.model.UpdateQuerySuggestionsConfigRequest
      .wrap(buildAwsValue())
}
object UpdateQuerySuggestionsConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UpdateQuerySuggestionsConfigRequest =
      zio.aws.kendra.model.UpdateQuerySuggestionsConfigRequest(
        indexId,
        mode.map(value => value),
        queryLogLookBackWindowInDays.map(value => value),
        includeQueriesWithoutUserInformation.map(value => value),
        minimumNumberOfQueryingUsers.map(value => value),
        minimumQueryCount.map(value => value)
      )
    def indexId: IndexId
    def mode: Optional[zio.aws.kendra.model.Mode]
    def queryLogLookBackWindowInDays: Optional[Integer]
    def includeQueriesWithoutUserInformation: Optional[ObjectBoolean]
    def minimumNumberOfQueryingUsers: Optional[MinimumNumberOfQueryingUsers]
    def minimumQueryCount: Optional[MinimumQueryCount]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getMode: ZIO[Any, AwsError, zio.aws.kendra.model.Mode] =
      AwsError.unwrapOptionField("mode", mode)
    def getQueryLogLookBackWindowInDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "queryLogLookBackWindowInDays",
        queryLogLookBackWindowInDays
      )
    def getIncludeQueriesWithoutUserInformation
        : ZIO[Any, AwsError, ObjectBoolean] = AwsError.unwrapOptionField(
      "includeQueriesWithoutUserInformation",
      includeQueriesWithoutUserInformation
    )
    def getMinimumNumberOfQueryingUsers
        : ZIO[Any, AwsError, MinimumNumberOfQueryingUsers] =
      AwsError.unwrapOptionField(
        "minimumNumberOfQueryingUsers",
        minimumNumberOfQueryingUsers
      )
    def getMinimumQueryCount: ZIO[Any, AwsError, MinimumQueryCount] =
      AwsError.unwrapOptionField("minimumQueryCount", minimumQueryCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsConfigRequest
  ) extends zio.aws.kendra.model.UpdateQuerySuggestionsConfigRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val mode: Optional[zio.aws.kendra.model.Mode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.kendra.model.Mode.wrap(value))
    override val queryLogLookBackWindowInDays: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryLogLookBackWindowInDays())
        .map(value => value: Integer)
    override val includeQueriesWithoutUserInformation: Optional[ObjectBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeQueriesWithoutUserInformation())
        .map(value => zio.aws.kendra.model.primitives.ObjectBoolean(value))
    override val minimumNumberOfQueryingUsers
        : Optional[MinimumNumberOfQueryingUsers] = zio.aws.core.internal
      .optionalFromNullable(impl.minimumNumberOfQueryingUsers())
      .map(value =>
        zio.aws.kendra.model.primitives.MinimumNumberOfQueryingUsers(value)
      )
    override val minimumQueryCount: Optional[MinimumQueryCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumQueryCount())
        .map(value => zio.aws.kendra.model.primitives.MinimumQueryCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsConfigRequest
  ): zio.aws.kendra.model.UpdateQuerySuggestionsConfigRequest.ReadOnly =
    new Wrapper(impl)
}
