package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait UserGroupResolutionMode {
  def unwrap
      : software.amazon.awssdk.services.kendra.model.UserGroupResolutionMode
}
object UserGroupResolutionMode {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.UserGroupResolutionMode
  ): zio.aws.kendra.model.UserGroupResolutionMode = value match {
    case software.amazon.awssdk.services.kendra.model.UserGroupResolutionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.UserGroupResolutionMode.AWS_SSO =>
      val r = AWS_SSO
      r
    case software.amazon.awssdk.services.kendra.model.UserGroupResolutionMode.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.UserGroupResolutionMode {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.UserGroupResolutionMode =
      software.amazon.awssdk.services.kendra.model.UserGroupResolutionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_SSO extends zio.aws.kendra.model.UserGroupResolutionMode {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.UserGroupResolutionMode =
      software.amazon.awssdk.services.kendra.model.UserGroupResolutionMode.AWS_SSO
  }
  case object NONE extends zio.aws.kendra.model.UserGroupResolutionMode {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.UserGroupResolutionMode =
      software.amazon.awssdk.services.kendra.model.UserGroupResolutionMode.NONE
  }
}
