package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.S3ObjectKey
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccessControlListConfiguration(
    keyPath: Optional[S3ObjectKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.AccessControlListConfiguration = {
    import AccessControlListConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.AccessControlListConfiguration
      .builder()
      .optionallyWith(
        keyPath.map(value => S3ObjectKey.unwrap(value): java.lang.String)
      )(_.keyPath)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.AccessControlListConfiguration.ReadOnly =
    zio.aws.kendra.model.AccessControlListConfiguration.wrap(buildAwsValue())
}
object AccessControlListConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.AccessControlListConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.AccessControlListConfiguration =
      zio.aws.kendra.model
        .AccessControlListConfiguration(keyPath.map(value => value))
    def keyPath: Optional[S3ObjectKey]
    def getKeyPath: ZIO[Any, AwsError, S3ObjectKey] =
      AwsError.unwrapOptionField("keyPath", keyPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.AccessControlListConfiguration
  ) extends zio.aws.kendra.model.AccessControlListConfiguration.ReadOnly {
    override val keyPath: Optional[S3ObjectKey] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPath())
      .map(value => zio.aws.kendra.model.primitives.S3ObjectKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.AccessControlListConfiguration
  ): zio.aws.kendra.model.AccessControlListConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
