package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.ColumnName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AclConfiguration(allowedGroupsColumnName: ColumnName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.AclConfiguration = {
    import AclConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.AclConfiguration
      .builder()
      .allowedGroupsColumnName(
        ColumnName.unwrap(allowedGroupsColumnName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.AclConfiguration.ReadOnly =
    zio.aws.kendra.model.AclConfiguration.wrap(buildAwsValue())
}
object AclConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.AclConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.AclConfiguration =
      zio.aws.kendra.model.AclConfiguration(allowedGroupsColumnName)
    def allowedGroupsColumnName: ColumnName
    def getAllowedGroupsColumnName: ZIO[Any, Nothing, ColumnName] =
      ZIO.succeed(allowedGroupsColumnName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.AclConfiguration
  ) extends zio.aws.kendra.model.AclConfiguration.ReadOnly {
    override val allowedGroupsColumnName: ColumnName =
      zio.aws.kendra.model.primitives.ColumnName(impl.allowedGroupsColumnName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.AclConfiguration
  ): zio.aws.kendra.model.AclConfiguration.ReadOnly = new Wrapper(impl)
}
