package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AdditionalResultAttributeValue(
    textWithHighlightsValue: Optional[zio.aws.kendra.model.TextWithHighlights] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.AdditionalResultAttributeValue = {
    import AdditionalResultAttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.AdditionalResultAttributeValue
      .builder()
      .optionallyWith(
        textWithHighlightsValue.map(value => value.buildAwsValue())
      )(_.textWithHighlightsValue)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.AdditionalResultAttributeValue.ReadOnly =
    zio.aws.kendra.model.AdditionalResultAttributeValue.wrap(buildAwsValue())
}
object AdditionalResultAttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.AdditionalResultAttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.AdditionalResultAttributeValue =
      zio.aws.kendra.model.AdditionalResultAttributeValue(
        textWithHighlightsValue.map(value => value.asEditable)
      )
    def textWithHighlightsValue
        : Optional[zio.aws.kendra.model.TextWithHighlights.ReadOnly]
    def getTextWithHighlightsValue
        : ZIO[Any, AwsError, zio.aws.kendra.model.TextWithHighlights.ReadOnly] =
      AwsError.unwrapOptionField(
        "textWithHighlightsValue",
        textWithHighlightsValue
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.AdditionalResultAttributeValue
  ) extends zio.aws.kendra.model.AdditionalResultAttributeValue.ReadOnly {
    override val textWithHighlightsValue
        : Optional[zio.aws.kendra.model.TextWithHighlights.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textWithHighlightsValue())
        .map(value => zio.aws.kendra.model.TextWithHighlights.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.AdditionalResultAttributeValue
  ): zio.aws.kendra.model.AdditionalResultAttributeValue.ReadOnly = new Wrapper(
    impl
  )
}
