package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceInclusionsExclusionsStringsMember,
  SecretArn,
  SiteId,
  SiteUrl
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AlfrescoConfiguration(
    siteUrl: SiteUrl,
    siteId: SiteId,
    secretArn: SecretArn,
    sslCertificateS3Path: zio.aws.kendra.model.S3Path,
    crawlSystemFolders: Optional[Boolean] = Optional.Absent,
    crawlComments: Optional[Boolean] = Optional.Absent,
    entityFilter: Optional[Iterable[zio.aws.kendra.model.AlfrescoEntity]] =
      Optional.Absent,
    documentLibraryFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    blogFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    wikiFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    inclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    exclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    vpcConfiguration: Optional[
      zio.aws.kendra.model.DataSourceVpcConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.AlfrescoConfiguration = {
    import AlfrescoConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.AlfrescoConfiguration
      .builder()
      .siteUrl(SiteUrl.unwrap(siteUrl): java.lang.String)
      .siteId(SiteId.unwrap(siteId): java.lang.String)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .sslCertificateS3Path(sslCertificateS3Path.buildAwsValue())
      .optionallyWith(
        crawlSystemFolders.map(value => value: java.lang.Boolean)
      )(_.crawlSystemFolders)
      .optionallyWith(crawlComments.map(value => value: java.lang.Boolean))(
        _.crawlComments
      )
      .optionallyWith(
        entityFilter.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.entityFilterWithStrings)
      .optionallyWith(
        documentLibraryFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentLibraryFieldMappings)
      .optionallyWith(
        blogFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blogFieldMappings)
      .optionallyWith(
        wikiFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wikiFieldMappings)
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.AlfrescoConfiguration.ReadOnly =
    zio.aws.kendra.model.AlfrescoConfiguration.wrap(buildAwsValue())
}
object AlfrescoConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.AlfrescoConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.AlfrescoConfiguration =
      zio.aws.kendra.model.AlfrescoConfiguration(
        siteUrl,
        siteId,
        secretArn,
        sslCertificateS3Path.asEditable,
        crawlSystemFolders.map(value => value),
        crawlComments.map(value => value),
        entityFilter.map(value => value),
        documentLibraryFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        blogFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        wikiFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value),
        vpcConfiguration.map(value => value.asEditable)
      )
    def siteUrl: SiteUrl
    def siteId: SiteId
    def secretArn: SecretArn
    def sslCertificateS3Path: zio.aws.kendra.model.S3Path.ReadOnly
    def crawlSystemFolders: Optional[Boolean]
    def crawlComments: Optional[Boolean]
    def entityFilter: Optional[List[zio.aws.kendra.model.AlfrescoEntity]]
    def documentLibraryFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def blogFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def wikiFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly]
    def getSiteUrl: ZIO[Any, Nothing, SiteUrl] = ZIO.succeed(siteUrl)
    def getSiteId: ZIO[Any, Nothing, SiteId] = ZIO.succeed(siteId)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getSslCertificateS3Path
        : ZIO[Any, Nothing, zio.aws.kendra.model.S3Path.ReadOnly] =
      ZIO.succeed(sslCertificateS3Path)
    def getCrawlSystemFolders: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlSystemFolders", crawlSystemFolders)
    def getCrawlComments: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlComments", crawlComments)
    def getEntityFilter
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.AlfrescoEntity]] =
      AwsError.unwrapOptionField("entityFilter", entityFilter)
    def getDocumentLibraryFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "documentLibraryFieldMappings",
      documentLibraryFieldMappings
    )
    def getBlogFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blogFieldMappings", blogFieldMappings)
    def getWikiFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("wikiFieldMappings", wikiFieldMappings)
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.AlfrescoConfiguration
  ) extends zio.aws.kendra.model.AlfrescoConfiguration.ReadOnly {
    override val siteUrl: SiteUrl =
      zio.aws.kendra.model.primitives.SiteUrl(impl.siteUrl())
    override val siteId: SiteId =
      zio.aws.kendra.model.primitives.SiteId(impl.siteId())
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val sslCertificateS3Path: zio.aws.kendra.model.S3Path.ReadOnly =
      zio.aws.kendra.model.S3Path.wrap(impl.sslCertificateS3Path())
    override val crawlSystemFolders: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlSystemFolders())
      .map(value => value: Boolean)
    override val crawlComments: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlComments())
      .map(value => value: Boolean)
    override val entityFilter
        : Optional[List[zio.aws.kendra.model.AlfrescoEntity]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entityFilter())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.AlfrescoEntity.wrap(item)
          }.toList
        )
    override val documentLibraryFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documentLibraryFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val blogFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blogFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val wikiFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.wikiFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value =>
          zio.aws.kendra.model.DataSourceVpcConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.AlfrescoConfiguration
  ): zio.aws.kendra.model.AlfrescoConfiguration.ReadOnly = new Wrapper(impl)
}
