package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentAttributeKey
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AttributeSuggestionsGetConfig(
    suggestionAttributes: Optional[Iterable[DocumentAttributeKey]] =
      Optional.Absent,
    additionalResponseAttributes: Optional[Iterable[DocumentAttributeKey]] =
      Optional.Absent,
    attributeFilter: Optional[zio.aws.kendra.model.AttributeFilter] =
      Optional.Absent,
    userContext: Optional[zio.aws.kendra.model.UserContext] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.AttributeSuggestionsGetConfig = {
    import AttributeSuggestionsGetConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.AttributeSuggestionsGetConfig
      .builder()
      .optionallyWith(
        suggestionAttributes.map(value =>
          value.map { item =>
            DocumentAttributeKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.suggestionAttributes)
      .optionallyWith(
        additionalResponseAttributes.map(value =>
          value.map { item =>
            DocumentAttributeKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalResponseAttributes)
      .optionallyWith(attributeFilter.map(value => value.buildAwsValue()))(
        _.attributeFilter
      )
      .optionallyWith(userContext.map(value => value.buildAwsValue()))(
        _.userContext
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.AttributeSuggestionsGetConfig.ReadOnly =
    zio.aws.kendra.model.AttributeSuggestionsGetConfig.wrap(buildAwsValue())
}
object AttributeSuggestionsGetConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.AttributeSuggestionsGetConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.AttributeSuggestionsGetConfig =
      zio.aws.kendra.model.AttributeSuggestionsGetConfig(
        suggestionAttributes.map(value => value),
        additionalResponseAttributes.map(value => value),
        attributeFilter.map(value => value.asEditable),
        userContext.map(value => value.asEditable)
      )
    def suggestionAttributes: Optional[List[DocumentAttributeKey]]
    def additionalResponseAttributes: Optional[List[DocumentAttributeKey]]
    def attributeFilter: Optional[zio.aws.kendra.model.AttributeFilter.ReadOnly]
    def userContext: Optional[zio.aws.kendra.model.UserContext.ReadOnly]
    def getSuggestionAttributes
        : ZIO[Any, AwsError, List[DocumentAttributeKey]] =
      AwsError.unwrapOptionField("suggestionAttributes", suggestionAttributes)
    def getAdditionalResponseAttributes
        : ZIO[Any, AwsError, List[DocumentAttributeKey]] =
      AwsError.unwrapOptionField(
        "additionalResponseAttributes",
        additionalResponseAttributes
      )
    def getAttributeFilter
        : ZIO[Any, AwsError, zio.aws.kendra.model.AttributeFilter.ReadOnly] =
      AwsError.unwrapOptionField("attributeFilter", attributeFilter)
    def getUserContext
        : ZIO[Any, AwsError, zio.aws.kendra.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("userContext", userContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.AttributeSuggestionsGetConfig
  ) extends zio.aws.kendra.model.AttributeSuggestionsGetConfig.ReadOnly {
    override val suggestionAttributes: Optional[List[DocumentAttributeKey]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suggestionAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives.DocumentAttributeKey(item)
          }.toList
        )
    override val additionalResponseAttributes
        : Optional[List[DocumentAttributeKey]] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalResponseAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives.DocumentAttributeKey(item)
        }.toList
      )
    override val attributeFilter
        : Optional[zio.aws.kendra.model.AttributeFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeFilter())
        .map(value => zio.aws.kendra.model.AttributeFilter.wrap(value))
    override val userContext
        : Optional[zio.aws.kendra.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userContext())
        .map(value => zio.aws.kendra.model.UserContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.AttributeSuggestionsGetConfig
  ): zio.aws.kendra.model.AttributeSuggestionsGetConfig.ReadOnly = new Wrapper(
    impl
  )
}
