package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AttributeSuggestionsUpdateConfig(
    suggestableConfigList: Optional[
      Iterable[zio.aws.kendra.model.SuggestableConfig]
    ] = Optional.Absent,
    attributeSuggestionsMode: Optional[
      zio.aws.kendra.model.AttributeSuggestionsMode
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.AttributeSuggestionsUpdateConfig = {
    import AttributeSuggestionsUpdateConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.AttributeSuggestionsUpdateConfig
      .builder()
      .optionallyWith(
        suggestableConfigList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suggestableConfigList)
      .optionallyWith(attributeSuggestionsMode.map(value => value.unwrap))(
        _.attributeSuggestionsMode
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.AttributeSuggestionsUpdateConfig.ReadOnly =
    zio.aws.kendra.model.AttributeSuggestionsUpdateConfig.wrap(buildAwsValue())
}
object AttributeSuggestionsUpdateConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.AttributeSuggestionsUpdateConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.AttributeSuggestionsUpdateConfig =
      zio.aws.kendra.model.AttributeSuggestionsUpdateConfig(
        suggestableConfigList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attributeSuggestionsMode.map(value => value)
      )
    def suggestableConfigList
        : Optional[List[zio.aws.kendra.model.SuggestableConfig.ReadOnly]]
    def attributeSuggestionsMode
        : Optional[zio.aws.kendra.model.AttributeSuggestionsMode]
    def getSuggestableConfigList: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.SuggestableConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("suggestableConfigList", suggestableConfigList)
    def getAttributeSuggestionsMode
        : ZIO[Any, AwsError, zio.aws.kendra.model.AttributeSuggestionsMode] =
      AwsError.unwrapOptionField(
        "attributeSuggestionsMode",
        attributeSuggestionsMode
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.AttributeSuggestionsUpdateConfig
  ) extends zio.aws.kendra.model.AttributeSuggestionsUpdateConfig.ReadOnly {
    override val suggestableConfigList
        : Optional[List[zio.aws.kendra.model.SuggestableConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suggestableConfigList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.SuggestableConfig.wrap(item)
          }.toList
        )
    override val attributeSuggestionsMode
        : Optional[zio.aws.kendra.model.AttributeSuggestionsMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeSuggestionsMode())
        .map(value => zio.aws.kendra.model.AttributeSuggestionsMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.AttributeSuggestionsUpdateConfig
  ): zio.aws.kendra.model.AttributeSuggestionsUpdateConfig.ReadOnly =
    new Wrapper(impl)
}
