package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{ErrorMessage, FeaturedResultsSetId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchDeleteFeaturedResultsSetError(
    id: FeaturedResultsSetId,
    errorCode: zio.aws.kendra.model.ErrorCode,
    errorMessage: ErrorMessage
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetError = {
    import BatchDeleteFeaturedResultsSetError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetError
      .builder()
      .id(FeaturedResultsSetId.unwrap(id): java.lang.String)
      .errorCode(errorCode.unwrap)
      .errorMessage(ErrorMessage.unwrap(errorMessage): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.BatchDeleteFeaturedResultsSetError.ReadOnly =
    zio.aws.kendra.model.BatchDeleteFeaturedResultsSetError
      .wrap(buildAwsValue())
}
object BatchDeleteFeaturedResultsSetError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.BatchDeleteFeaturedResultsSetError =
      zio.aws.kendra.model
        .BatchDeleteFeaturedResultsSetError(id, errorCode, errorMessage)
    def id: FeaturedResultsSetId
    def errorCode: zio.aws.kendra.model.ErrorCode
    def errorMessage: ErrorMessage
    def getId: ZIO[Any, Nothing, FeaturedResultsSetId] = ZIO.succeed(id)
    def getErrorCode: ZIO[Any, Nothing, zio.aws.kendra.model.ErrorCode] =
      ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, ErrorMessage] =
      ZIO.succeed(errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetError
  ) extends zio.aws.kendra.model.BatchDeleteFeaturedResultsSetError.ReadOnly {
    override val id: FeaturedResultsSetId =
      zio.aws.kendra.model.primitives.FeaturedResultsSetId(impl.id())
    override val errorCode: zio.aws.kendra.model.ErrorCode =
      zio.aws.kendra.model.ErrorCode.wrap(impl.errorCode())
    override val errorMessage: ErrorMessage =
      zio.aws.kendra.model.primitives.ErrorMessage(impl.errorMessage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetError
  ): zio.aws.kendra.model.BatchDeleteFeaturedResultsSetError.ReadOnly =
    new Wrapper(impl)
}
