package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{FeaturedResultsSetId, IndexId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchDeleteFeaturedResultsSetRequest(
    indexId: IndexId,
    featuredResultsSetIds: Iterable[FeaturedResultsSetId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetRequest = {
    import BatchDeleteFeaturedResultsSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .featuredResultsSetIds(featuredResultsSetIds.map { item =>
        FeaturedResultsSetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.BatchDeleteFeaturedResultsSetRequest.ReadOnly =
    zio.aws.kendra.model.BatchDeleteFeaturedResultsSetRequest
      .wrap(buildAwsValue())
}
object BatchDeleteFeaturedResultsSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.BatchDeleteFeaturedResultsSetRequest =
      zio.aws.kendra.model
        .BatchDeleteFeaturedResultsSetRequest(indexId, featuredResultsSetIds)
    def indexId: IndexId
    def featuredResultsSetIds: List[FeaturedResultsSetId]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getFeaturedResultsSetIds
        : ZIO[Any, Nothing, List[FeaturedResultsSetId]] =
      ZIO.succeed(featuredResultsSetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetRequest
  ) extends zio.aws.kendra.model.BatchDeleteFeaturedResultsSetRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val featuredResultsSetIds: List[FeaturedResultsSetId] = impl
      .featuredResultsSetIds()
      .asScala
      .map { item =>
        zio.aws.kendra.model.primitives.FeaturedResultsSetId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetRequest
  ): zio.aws.kendra.model.BatchDeleteFeaturedResultsSetRequest.ReadOnly =
    new Wrapper(impl)
}
