package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchDeleteFeaturedResultsSetResponse(
    errors: Iterable[zio.aws.kendra.model.BatchDeleteFeaturedResultsSetError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetResponse = {
    import BatchDeleteFeaturedResultsSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetResponse
      .builder()
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.BatchDeleteFeaturedResultsSetResponse.ReadOnly =
    zio.aws.kendra.model.BatchDeleteFeaturedResultsSetResponse
      .wrap(buildAwsValue())
}
object BatchDeleteFeaturedResultsSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.BatchDeleteFeaturedResultsSetResponse =
      zio.aws.kendra.model.BatchDeleteFeaturedResultsSetResponse(errors.map {
        item =>
          item.asEditable
      })
    def errors
        : List[zio.aws.kendra.model.BatchDeleteFeaturedResultsSetError.ReadOnly]
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.kendra.model.BatchDeleteFeaturedResultsSetError.ReadOnly
    ]] = ZIO.succeed(errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetResponse
  ) extends zio.aws.kendra.model.BatchDeleteFeaturedResultsSetResponse.ReadOnly {
    override val errors: List[
      zio.aws.kendra.model.BatchDeleteFeaturedResultsSetError.ReadOnly
    ] = impl
      .errors()
      .asScala
      .map { item =>
        zio.aws.kendra.model.BatchDeleteFeaturedResultsSetError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetResponse
  ): zio.aws.kendra.model.BatchDeleteFeaturedResultsSetResponse.ReadOnly =
    new Wrapper(impl)
}
