package zio.aws.kendra.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kendra.model.primitives.{QueryCapacityUnit, StorageCapacityUnit}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CapacityUnitsConfiguration(
    storageCapacityUnits: StorageCapacityUnit,
    queryCapacityUnits: QueryCapacityUnit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CapacityUnitsConfiguration = {
    import CapacityUnitsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CapacityUnitsConfiguration
      .builder()
      .storageCapacityUnits(
        StorageCapacityUnit.unwrap(storageCapacityUnits): Integer
      )
      .queryCapacityUnits(QueryCapacityUnit.unwrap(queryCapacityUnits): Integer)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly =
    zio.aws.kendra.model.CapacityUnitsConfiguration.wrap(buildAwsValue())
}
object CapacityUnitsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CapacityUnitsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CapacityUnitsConfiguration =
      zio.aws.kendra.model
        .CapacityUnitsConfiguration(storageCapacityUnits, queryCapacityUnits)
    def storageCapacityUnits: StorageCapacityUnit
    def queryCapacityUnits: QueryCapacityUnit
    def getStorageCapacityUnits: ZIO[Any, Nothing, StorageCapacityUnit] =
      ZIO.succeed(storageCapacityUnits)
    def getQueryCapacityUnits: ZIO[Any, Nothing, QueryCapacityUnit] =
      ZIO.succeed(queryCapacityUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CapacityUnitsConfiguration
  ) extends zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly {
    override val storageCapacityUnits: StorageCapacityUnit =
      zio.aws.kendra.model.primitives
        .StorageCapacityUnit(impl.storageCapacityUnits())
    override val queryCapacityUnits: QueryCapacityUnit =
      zio.aws.kendra.model.primitives
        .QueryCapacityUnit(impl.queryCapacityUnits())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CapacityUnitsConfiguration
  ): zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
