package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentAttributeKey
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CollapseConfiguration(
    documentAttributeKey: DocumentAttributeKey,
    sortingConfigurations: Optional[
      Iterable[zio.aws.kendra.model.SortingConfiguration]
    ] = Optional.Absent,
    missingAttributeKeyStrategy: Optional[
      zio.aws.kendra.model.MissingAttributeKeyStrategy
    ] = Optional.Absent,
    expand: Optional[Boolean] = Optional.Absent,
    expandConfiguration: Optional[zio.aws.kendra.model.ExpandConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CollapseConfiguration = {
    import CollapseConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CollapseConfiguration
      .builder()
      .documentAttributeKey(
        DocumentAttributeKey.unwrap(documentAttributeKey): java.lang.String
      )
      .optionallyWith(
        sortingConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sortingConfigurations)
      .optionallyWith(missingAttributeKeyStrategy.map(value => value.unwrap))(
        _.missingAttributeKeyStrategy
      )
      .optionallyWith(expand.map(value => value: java.lang.Boolean))(_.expand)
      .optionallyWith(expandConfiguration.map(value => value.buildAwsValue()))(
        _.expandConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CollapseConfiguration.ReadOnly =
    zio.aws.kendra.model.CollapseConfiguration.wrap(buildAwsValue())
}
object CollapseConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CollapseConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CollapseConfiguration =
      zio.aws.kendra.model.CollapseConfiguration(
        documentAttributeKey,
        sortingConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        missingAttributeKeyStrategy.map(value => value),
        expand.map(value => value),
        expandConfiguration.map(value => value.asEditable)
      )
    def documentAttributeKey: DocumentAttributeKey
    def sortingConfigurations
        : Optional[List[zio.aws.kendra.model.SortingConfiguration.ReadOnly]]
    def missingAttributeKeyStrategy
        : Optional[zio.aws.kendra.model.MissingAttributeKeyStrategy]
    def expand: Optional[Boolean]
    def expandConfiguration
        : Optional[zio.aws.kendra.model.ExpandConfiguration.ReadOnly]
    def getDocumentAttributeKey: ZIO[Any, Nothing, DocumentAttributeKey] =
      ZIO.succeed(documentAttributeKey)
    def getSortingConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.SortingConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("sortingConfigurations", sortingConfigurations)
    def getMissingAttributeKeyStrategy
        : ZIO[Any, AwsError, zio.aws.kendra.model.MissingAttributeKeyStrategy] =
      AwsError.unwrapOptionField(
        "missingAttributeKeyStrategy",
        missingAttributeKeyStrategy
      )
    def getExpand: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("expand", expand)
    def getExpandConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ExpandConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("expandConfiguration", expandConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CollapseConfiguration
  ) extends zio.aws.kendra.model.CollapseConfiguration.ReadOnly {
    override val documentAttributeKey: DocumentAttributeKey =
      zio.aws.kendra.model.primitives
        .DocumentAttributeKey(impl.documentAttributeKey())
    override val sortingConfigurations
        : Optional[List[zio.aws.kendra.model.SortingConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortingConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.SortingConfiguration.wrap(item)
          }.toList
        )
    override val missingAttributeKeyStrategy
        : Optional[zio.aws.kendra.model.MissingAttributeKeyStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.missingAttributeKeyStrategy())
        .map(value =>
          zio.aws.kendra.model.MissingAttributeKeyStrategy.wrap(value)
        )
    override val expand: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.expand())
      .map(value => value: Boolean)
    override val expandConfiguration
        : Optional[zio.aws.kendra.model.ExpandConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expandConfiguration())
        .map(value => zio.aws.kendra.model.ExpandConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CollapseConfiguration
  ): zio.aws.kendra.model.CollapseConfiguration.ReadOnly = new Wrapper(impl)
}
