package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CollapsedResultDetail(
    documentAttribute: zio.aws.kendra.model.DocumentAttribute,
    expandedResults: Optional[
      Iterable[zio.aws.kendra.model.ExpandedResultItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CollapsedResultDetail = {
    import CollapsedResultDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CollapsedResultDetail
      .builder()
      .documentAttribute(documentAttribute.buildAwsValue())
      .optionallyWith(
        expandedResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.expandedResults)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CollapsedResultDetail.ReadOnly =
    zio.aws.kendra.model.CollapsedResultDetail.wrap(buildAwsValue())
}
object CollapsedResultDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CollapsedResultDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CollapsedResultDetail =
      zio.aws.kendra.model.CollapsedResultDetail(
        documentAttribute.asEditable,
        expandedResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def documentAttribute: zio.aws.kendra.model.DocumentAttribute.ReadOnly
    def expandedResults
        : Optional[List[zio.aws.kendra.model.ExpandedResultItem.ReadOnly]]
    def getDocumentAttribute
        : ZIO[Any, Nothing, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      ZIO.succeed(documentAttribute)
    def getExpandedResults: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.ExpandedResultItem.ReadOnly
    ]] = AwsError.unwrapOptionField("expandedResults", expandedResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CollapsedResultDetail
  ) extends zio.aws.kendra.model.CollapsedResultDetail.ReadOnly {
    override val documentAttribute
        : zio.aws.kendra.model.DocumentAttribute.ReadOnly =
      zio.aws.kendra.model.DocumentAttribute.wrap(impl.documentAttribute())
    override val expandedResults
        : Optional[List[zio.aws.kendra.model.ExpandedResultItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expandedResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.ExpandedResultItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CollapsedResultDetail
  ): zio.aws.kendra.model.CollapsedResultDetail.ReadOnly = new Wrapper(impl)
}
