package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConfluencePageConfiguration(
    pageFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.ConfluencePageToIndexFieldMapping]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ConfluencePageConfiguration = {
    import ConfluencePageConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ConfluencePageConfiguration
      .builder()
      .optionallyWith(
        pageFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pageFieldMappings)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ConfluencePageConfiguration.ReadOnly =
    zio.aws.kendra.model.ConfluencePageConfiguration.wrap(buildAwsValue())
}
object ConfluencePageConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ConfluencePageConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ConfluencePageConfiguration =
      zio.aws.kendra.model.ConfluencePageConfiguration(
        pageFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pageFieldMappings: Optional[
      List[zio.aws.kendra.model.ConfluencePageToIndexFieldMapping.ReadOnly]
    ]
    def getPageFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.ConfluencePageToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("pageFieldMappings", pageFieldMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ConfluencePageConfiguration
  ) extends zio.aws.kendra.model.ConfluencePageConfiguration.ReadOnly {
    override val pageFieldMappings: Optional[
      List[zio.aws.kendra.model.ConfluencePageToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pageFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.ConfluencePageToIndexFieldMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ConfluencePageConfiguration
  ): zio.aws.kendra.model.ConfluencePageConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
