package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait ConfluenceVersion {
  def unwrap: software.amazon.awssdk.services.kendra.model.ConfluenceVersion
}
object ConfluenceVersion {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.ConfluenceVersion
  ): zio.aws.kendra.model.ConfluenceVersion = value match {
    case software.amazon.awssdk.services.kendra.model.ConfluenceVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.ConfluenceVersion.CLOUD =>
      val r = CLOUD
      r
    case software.amazon.awssdk.services.kendra.model.ConfluenceVersion.SERVER =>
      val r = SERVER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.ConfluenceVersion {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConfluenceVersion =
      software.amazon.awssdk.services.kendra.model.ConfluenceVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object CLOUD extends zio.aws.kendra.model.ConfluenceVersion {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConfluenceVersion =
      software.amazon.awssdk.services.kendra.model.ConfluenceVersion.CLOUD
  }
  case object SERVER extends zio.aws.kendra.model.ConfluenceVersion {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConfluenceVersion =
      software.amazon.awssdk.services.kendra.model.ConfluenceVersion.SERVER
  }
}
