package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Correction(
    beginOffset: Optional[Integer] = Optional.Absent,
    endOffset: Optional[Integer] = Optional.Absent,
    term: Optional[String] = Optional.Absent,
    correctedTerm: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.Correction = {
    import Correction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Correction
      .builder()
      .optionallyWith(beginOffset.map(value => value: java.lang.Integer))(
        _.beginOffset
      )
      .optionallyWith(endOffset.map(value => value: java.lang.Integer))(
        _.endOffset
      )
      .optionallyWith(term.map(value => value: java.lang.String))(_.term)
      .optionallyWith(correctedTerm.map(value => value: java.lang.String))(
        _.correctedTerm
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Correction.ReadOnly =
    zio.aws.kendra.model.Correction.wrap(buildAwsValue())
}
object Correction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Correction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Correction =
      zio.aws.kendra.model.Correction(
        beginOffset.map(value => value),
        endOffset.map(value => value),
        term.map(value => value),
        correctedTerm.map(value => value)
      )
    def beginOffset: Optional[Integer]
    def endOffset: Optional[Integer]
    def term: Optional[String]
    def correctedTerm: Optional[String]
    def getBeginOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("beginOffset", beginOffset)
    def getEndOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endOffset", endOffset)
    def getTerm: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("term", term)
    def getCorrectedTerm: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("correctedTerm", correctedTerm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Correction
  ) extends zio.aws.kendra.model.Correction.ReadOnly {
    override val beginOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.beginOffset())
      .map(value => value: Integer)
    override val endOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.endOffset())
      .map(value => value: Integer)
    override val term: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.term())
      .map(value => value: String)
    override val correctedTerm: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.correctedTerm())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Correction
  ): zio.aws.kendra.model.Correction.ReadOnly = new Wrapper(impl)
}
