package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.AccessControlConfigurationId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateAccessControlConfigurationResponse(
    id: AccessControlConfigurationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationResponse = {
    import CreateAccessControlConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationResponse
      .builder()
      .id(AccessControlConfigurationId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.CreateAccessControlConfigurationResponse.ReadOnly =
    zio.aws.kendra.model.CreateAccessControlConfigurationResponse
      .wrap(buildAwsValue())
}
object CreateAccessControlConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.CreateAccessControlConfigurationResponse =
      zio.aws.kendra.model.CreateAccessControlConfigurationResponse(id)
    def id: AccessControlConfigurationId
    def getId: ZIO[Any, Nothing, AccessControlConfigurationId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationResponse
  ) extends zio.aws.kendra.model.CreateAccessControlConfigurationResponse.ReadOnly {
    override val id: AccessControlConfigurationId =
      zio.aws.kendra.model.primitives.AccessControlConfigurationId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationResponse
  ): zio.aws.kendra.model.CreateAccessControlConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
