package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DataSourceId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateDataSourceResponse(id: DataSourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateDataSourceResponse = {
    import CreateDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateDataSourceResponse
      .builder()
      .id(DataSourceId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CreateDataSourceResponse.ReadOnly =
    zio.aws.kendra.model.CreateDataSourceResponse.wrap(buildAwsValue())
}
object CreateDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CreateDataSourceResponse =
      zio.aws.kendra.model.CreateDataSourceResponse(id)
    def id: DataSourceId
    def getId: ZIO[Any, Nothing, DataSourceId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateDataSourceResponse
  ) extends zio.aws.kendra.model.CreateDataSourceResponse.ReadOnly {
    override val id: DataSourceId =
      zio.aws.kendra.model.primitives.DataSourceId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateDataSourceResponse
  ): zio.aws.kendra.model.CreateDataSourceResponse.ReadOnly = new Wrapper(impl)
}
