package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.ExperienceId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateExperienceResponse(id: ExperienceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateExperienceResponse = {
    import CreateExperienceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateExperienceResponse
      .builder()
      .id(ExperienceId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CreateExperienceResponse.ReadOnly =
    zio.aws.kendra.model.CreateExperienceResponse.wrap(buildAwsValue())
}
object CreateExperienceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateExperienceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CreateExperienceResponse =
      zio.aws.kendra.model.CreateExperienceResponse(id)
    def id: ExperienceId
    def getId: ZIO[Any, Nothing, ExperienceId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateExperienceResponse
  ) extends zio.aws.kendra.model.CreateExperienceResponse.ReadOnly {
    override val id: ExperienceId =
      zio.aws.kendra.model.primitives.ExperienceId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateExperienceResponse
  ): zio.aws.kendra.model.CreateExperienceResponse.ReadOnly = new Wrapper(impl)
}
