package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ClientTokenName,
  RoleArn,
  LanguageCode,
  FaqName,
  IndexId,
  Description
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateFaqRequest(
    indexId: IndexId,
    name: FaqName,
    description: Optional[Description] = Optional.Absent,
    s3Path: zio.aws.kendra.model.S3Path,
    roleArn: RoleArn,
    tags: Optional[Iterable[zio.aws.kendra.model.Tag]] = Optional.Absent,
    fileFormat: Optional[zio.aws.kendra.model.FaqFileFormat] = Optional.Absent,
    clientToken: Optional[ClientTokenName] = Optional.Absent,
    languageCode: Optional[LanguageCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateFaqRequest = {
    import CreateFaqRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateFaqRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .name(FaqName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .s3Path(s3Path.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(fileFormat.map(value => value.unwrap))(_.fileFormat)
      .optionallyWith(
        clientToken.map(value =>
          ClientTokenName.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(
        languageCode.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.languageCode)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CreateFaqRequest.ReadOnly =
    zio.aws.kendra.model.CreateFaqRequest.wrap(buildAwsValue())
}
object CreateFaqRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateFaqRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CreateFaqRequest =
      zio.aws.kendra.model.CreateFaqRequest(
        indexId,
        name,
        description.map(value => value),
        s3Path.asEditable,
        roleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fileFormat.map(value => value),
        clientToken.map(value => value),
        languageCode.map(value => value)
      )
    def indexId: IndexId
    def name: FaqName
    def description: Optional[Description]
    def s3Path: zio.aws.kendra.model.S3Path.ReadOnly
    def roleArn: RoleArn
    def tags: Optional[List[zio.aws.kendra.model.Tag.ReadOnly]]
    def fileFormat: Optional[zio.aws.kendra.model.FaqFileFormat]
    def clientToken: Optional[ClientTokenName]
    def languageCode: Optional[LanguageCode]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getName: ZIO[Any, Nothing, FaqName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getS3Path: ZIO[Any, Nothing, zio.aws.kendra.model.S3Path.ReadOnly] =
      ZIO.succeed(s3Path)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.kendra.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFileFormat: ZIO[Any, AwsError, zio.aws.kendra.model.FaqFileFormat] =
      AwsError.unwrapOptionField("fileFormat", fileFormat)
    def getClientToken: ZIO[Any, AwsError, ClientTokenName] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getLanguageCode: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateFaqRequest
  ) extends zio.aws.kendra.model.CreateFaqRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val name: FaqName =
      zio.aws.kendra.model.primitives.FaqName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val s3Path: zio.aws.kendra.model.S3Path.ReadOnly =
      zio.aws.kendra.model.S3Path.wrap(impl.s3Path())
    override val roleArn: RoleArn =
      zio.aws.kendra.model.primitives.RoleArn(impl.roleArn())
    override val tags: Optional[List[zio.aws.kendra.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Tag.wrap(item)
          }.toList
        )
    override val fileFormat: Optional[zio.aws.kendra.model.FaqFileFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileFormat())
        .map(value => zio.aws.kendra.model.FaqFileFormat.wrap(value))
    override val clientToken: Optional[ClientTokenName] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.kendra.model.primitives.ClientTokenName(value))
    override val languageCode: Optional[LanguageCode] = zio.aws.core.internal
      .optionalFromNullable(impl.languageCode())
      .map(value => zio.aws.kendra.model.primitives.LanguageCode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateFaqRequest
  ): zio.aws.kendra.model.CreateFaqRequest.ReadOnly = new Wrapper(impl)
}
