package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ClientTokenName,
  QueryText,
  FeaturedResultsSetName,
  IndexId,
  FeaturedResultsSetDescription
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateFeaturedResultsSetRequest(
    indexId: IndexId,
    featuredResultsSetName: FeaturedResultsSetName,
    description: Optional[FeaturedResultsSetDescription] = Optional.Absent,
    clientToken: Optional[ClientTokenName] = Optional.Absent,
    status: Optional[zio.aws.kendra.model.FeaturedResultsSetStatus] =
      Optional.Absent,
    queryTexts: Optional[Iterable[QueryText]] = Optional.Absent,
    featuredDocuments: Optional[
      Iterable[zio.aws.kendra.model.FeaturedDocument]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.kendra.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateFeaturedResultsSetRequest = {
    import CreateFeaturedResultsSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateFeaturedResultsSetRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .featuredResultsSetName(
        FeaturedResultsSetName.unwrap(featuredResultsSetName): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          FeaturedResultsSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        clientToken.map(value =>
          ClientTokenName.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        queryTexts.map(value =>
          value.map { item =>
            QueryText.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.queryTexts)
      .optionallyWith(
        featuredDocuments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.featuredDocuments)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.CreateFeaturedResultsSetRequest.ReadOnly =
    zio.aws.kendra.model.CreateFeaturedResultsSetRequest.wrap(buildAwsValue())
}
object CreateFeaturedResultsSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateFeaturedResultsSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CreateFeaturedResultsSetRequest =
      zio.aws.kendra.model.CreateFeaturedResultsSetRequest(
        indexId,
        featuredResultsSetName,
        description.map(value => value),
        clientToken.map(value => value),
        status.map(value => value),
        queryTexts.map(value => value),
        featuredDocuments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def indexId: IndexId
    def featuredResultsSetName: FeaturedResultsSetName
    def description: Optional[FeaturedResultsSetDescription]
    def clientToken: Optional[ClientTokenName]
    def status: Optional[zio.aws.kendra.model.FeaturedResultsSetStatus]
    def queryTexts: Optional[List[QueryText]]
    def featuredDocuments
        : Optional[List[zio.aws.kendra.model.FeaturedDocument.ReadOnly]]
    def tags: Optional[List[zio.aws.kendra.model.Tag.ReadOnly]]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getFeaturedResultsSetName: ZIO[Any, Nothing, FeaturedResultsSetName] =
      ZIO.succeed(featuredResultsSetName)
    def getDescription: ZIO[Any, AwsError, FeaturedResultsSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, ClientTokenName] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.kendra.model.FeaturedResultsSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getQueryTexts: ZIO[Any, AwsError, List[QueryText]] =
      AwsError.unwrapOptionField("queryTexts", queryTexts)
    def getFeaturedDocuments: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.FeaturedDocument.ReadOnly
    ]] = AwsError.unwrapOptionField("featuredDocuments", featuredDocuments)
    def getTags: ZIO[Any, AwsError, List[zio.aws.kendra.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateFeaturedResultsSetRequest
  ) extends zio.aws.kendra.model.CreateFeaturedResultsSetRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val featuredResultsSetName: FeaturedResultsSetName =
      zio.aws.kendra.model.primitives
        .FeaturedResultsSetName(impl.featuredResultsSetName())
    override val description: Optional[FeaturedResultsSetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.kendra.model.primitives.FeaturedResultsSetDescription(value)
        )
    override val clientToken: Optional[ClientTokenName] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.kendra.model.primitives.ClientTokenName(value))
    override val status
        : Optional[zio.aws.kendra.model.FeaturedResultsSetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kendra.model.FeaturedResultsSetStatus.wrap(value))
    override val queryTexts: Optional[List[QueryText]] = zio.aws.core.internal
      .optionalFromNullable(impl.queryTexts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives.QueryText(item)
        }.toList
      )
    override val featuredDocuments
        : Optional[List[zio.aws.kendra.model.FeaturedDocument.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featuredDocuments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.FeaturedDocument.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.kendra.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateFeaturedResultsSetRequest
  ): zio.aws.kendra.model.CreateFeaturedResultsSetRequest.ReadOnly =
    new Wrapper(impl)
}
