package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateFeaturedResultsSetResponse(
    featuredResultsSet: Optional[zio.aws.kendra.model.FeaturedResultsSet] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateFeaturedResultsSetResponse = {
    import CreateFeaturedResultsSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateFeaturedResultsSetResponse
      .builder()
      .optionallyWith(featuredResultsSet.map(value => value.buildAwsValue()))(
        _.featuredResultsSet
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.CreateFeaturedResultsSetResponse.ReadOnly =
    zio.aws.kendra.model.CreateFeaturedResultsSetResponse.wrap(buildAwsValue())
}
object CreateFeaturedResultsSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateFeaturedResultsSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CreateFeaturedResultsSetResponse =
      zio.aws.kendra.model.CreateFeaturedResultsSetResponse(
        featuredResultsSet.map(value => value.asEditable)
      )
    def featuredResultsSet
        : Optional[zio.aws.kendra.model.FeaturedResultsSet.ReadOnly]
    def getFeaturedResultsSet
        : ZIO[Any, AwsError, zio.aws.kendra.model.FeaturedResultsSet.ReadOnly] =
      AwsError.unwrapOptionField("featuredResultsSet", featuredResultsSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateFeaturedResultsSetResponse
  ) extends zio.aws.kendra.model.CreateFeaturedResultsSetResponse.ReadOnly {
    override val featuredResultsSet
        : Optional[zio.aws.kendra.model.FeaturedResultsSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featuredResultsSet())
        .map(value => zio.aws.kendra.model.FeaturedResultsSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateFeaturedResultsSetResponse
  ): zio.aws.kendra.model.CreateFeaturedResultsSetResponse.ReadOnly =
    new Wrapper(impl)
}
