package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.QuerySuggestionsBlockListId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateQuerySuggestionsBlockListResponse(
    id: Optional[QuerySuggestionsBlockListId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListResponse = {
    import CreateQuerySuggestionsBlockListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListResponse
      .builder()
      .optionallyWith(
        id.map(value =>
          QuerySuggestionsBlockListId.unwrap(value): java.lang.String
        )
      )(_.id)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.CreateQuerySuggestionsBlockListResponse.ReadOnly =
    zio.aws.kendra.model.CreateQuerySuggestionsBlockListResponse
      .wrap(buildAwsValue())
}
object CreateQuerySuggestionsBlockListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.CreateQuerySuggestionsBlockListResponse =
      zio.aws.kendra.model
        .CreateQuerySuggestionsBlockListResponse(id.map(value => value))
    def id: Optional[QuerySuggestionsBlockListId]
    def getId: ZIO[Any, AwsError, QuerySuggestionsBlockListId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListResponse
  ) extends zio.aws.kendra.model.CreateQuerySuggestionsBlockListResponse.ReadOnly {
    override val id: Optional[QuerySuggestionsBlockListId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.kendra.model.primitives.QuerySuggestionsBlockListId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListResponse
  ): zio.aws.kendra.model.CreateQuerySuggestionsBlockListResponse.ReadOnly =
    new Wrapper(impl)
}
