package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ClientTokenName,
  RoleArn,
  IndexId,
  Description,
  ThesaurusName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateThesaurusRequest(
    indexId: IndexId,
    name: ThesaurusName,
    description: Optional[Description] = Optional.Absent,
    roleArn: RoleArn,
    tags: Optional[Iterable[zio.aws.kendra.model.Tag]] = Optional.Absent,
    sourceS3Path: zio.aws.kendra.model.S3Path,
    clientToken: Optional[ClientTokenName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateThesaurusRequest = {
    import CreateThesaurusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateThesaurusRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .name(ThesaurusName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .sourceS3Path(sourceS3Path.buildAwsValue())
      .optionallyWith(
        clientToken.map(value =>
          ClientTokenName.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CreateThesaurusRequest.ReadOnly =
    zio.aws.kendra.model.CreateThesaurusRequest.wrap(buildAwsValue())
}
object CreateThesaurusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateThesaurusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CreateThesaurusRequest =
      zio.aws.kendra.model.CreateThesaurusRequest(
        indexId,
        name,
        description.map(value => value),
        roleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceS3Path.asEditable,
        clientToken.map(value => value)
      )
    def indexId: IndexId
    def name: ThesaurusName
    def description: Optional[Description]
    def roleArn: RoleArn
    def tags: Optional[List[zio.aws.kendra.model.Tag.ReadOnly]]
    def sourceS3Path: zio.aws.kendra.model.S3Path.ReadOnly
    def clientToken: Optional[ClientTokenName]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getName: ZIO[Any, Nothing, ThesaurusName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.kendra.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSourceS3Path
        : ZIO[Any, Nothing, zio.aws.kendra.model.S3Path.ReadOnly] =
      ZIO.succeed(sourceS3Path)
    def getClientToken: ZIO[Any, AwsError, ClientTokenName] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateThesaurusRequest
  ) extends zio.aws.kendra.model.CreateThesaurusRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val name: ThesaurusName =
      zio.aws.kendra.model.primitives.ThesaurusName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val roleArn: RoleArn =
      zio.aws.kendra.model.primitives.RoleArn(impl.roleArn())
    override val tags: Optional[List[zio.aws.kendra.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Tag.wrap(item)
          }.toList
        )
    override val sourceS3Path: zio.aws.kendra.model.S3Path.ReadOnly =
      zio.aws.kendra.model.S3Path.wrap(impl.sourceS3Path())
    override val clientToken: Optional[ClientTokenName] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.kendra.model.primitives.ClientTokenName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateThesaurusRequest
  ): zio.aws.kendra.model.CreateThesaurusRequest.ReadOnly = new Wrapper(impl)
}
