package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.ThesaurusId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateThesaurusResponse(
    id: Optional[ThesaurusId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateThesaurusResponse = {
    import CreateThesaurusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateThesaurusResponse
      .builder()
      .optionallyWith(
        id.map(value => ThesaurusId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CreateThesaurusResponse.ReadOnly =
    zio.aws.kendra.model.CreateThesaurusResponse.wrap(buildAwsValue())
}
object CreateThesaurusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateThesaurusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CreateThesaurusResponse =
      zio.aws.kendra.model.CreateThesaurusResponse(id.map(value => value))
    def id: Optional[ThesaurusId]
    def getId: ZIO[Any, AwsError, ThesaurusId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateThesaurusResponse
  ) extends zio.aws.kendra.model.CreateThesaurusResponse.ReadOnly {
    override val id: Optional[ThesaurusId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ThesaurusId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateThesaurusResponse
  ): zio.aws.kendra.model.CreateThesaurusResponse.ReadOnly = new Wrapper(impl)
}
