package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.RoleArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomDocumentEnrichmentConfiguration(
    inlineConfigurations: Optional[
      Iterable[zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration]
    ] = Optional.Absent,
    preExtractionHookConfiguration: Optional[
      zio.aws.kendra.model.HookConfiguration
    ] = Optional.Absent,
    postExtractionHookConfiguration: Optional[
      zio.aws.kendra.model.HookConfiguration
    ] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CustomDocumentEnrichmentConfiguration = {
    import CustomDocumentEnrichmentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CustomDocumentEnrichmentConfiguration
      .builder()
      .optionallyWith(
        inlineConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inlineConfigurations)
      .optionallyWith(
        preExtractionHookConfiguration.map(value => value.buildAwsValue())
      )(_.preExtractionHookConfiguration)
      .optionallyWith(
        postExtractionHookConfiguration.map(value => value.buildAwsValue())
      )(_.postExtractionHookConfiguration)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly =
    zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration
      .wrap(buildAwsValue())
}
object CustomDocumentEnrichmentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CustomDocumentEnrichmentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration =
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration(
        inlineConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        preExtractionHookConfiguration.map(value => value.asEditable),
        postExtractionHookConfiguration.map(value => value.asEditable),
        roleArn.map(value => value)
      )
    def inlineConfigurations: Optional[List[
      zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration.ReadOnly
    ]]
    def preExtractionHookConfiguration
        : Optional[zio.aws.kendra.model.HookConfiguration.ReadOnly]
    def postExtractionHookConfiguration
        : Optional[zio.aws.kendra.model.HookConfiguration.ReadOnly]
    def roleArn: Optional[RoleArn]
    def getInlineConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("inlineConfigurations", inlineConfigurations)
    def getPreExtractionHookConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.HookConfiguration.ReadOnly] =
      AwsError.unwrapOptionField(
        "preExtractionHookConfiguration",
        preExtractionHookConfiguration
      )
    def getPostExtractionHookConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.HookConfiguration.ReadOnly] =
      AwsError.unwrapOptionField(
        "postExtractionHookConfiguration",
        postExtractionHookConfiguration
      )
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CustomDocumentEnrichmentConfiguration
  ) extends zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly {
    override val inlineConfigurations: Optional[List[
      zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.inlineConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration
            .wrap(item)
        }.toList
      )
    override val preExtractionHookConfiguration
        : Optional[zio.aws.kendra.model.HookConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preExtractionHookConfiguration())
        .map(value => zio.aws.kendra.model.HookConfiguration.wrap(value))
    override val postExtractionHookConfiguration
        : Optional[zio.aws.kendra.model.HookConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postExtractionHookConfiguration())
        .map(value => zio.aws.kendra.model.HookConfiguration.wrap(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CustomDocumentEnrichmentConfiguration
  ): zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly =
    new Wrapper(impl)
}
