package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataSourceConfiguration(
    s3Configuration: Optional[zio.aws.kendra.model.S3DataSourceConfiguration] =
      Optional.Absent,
    sharePointConfiguration: Optional[
      zio.aws.kendra.model.SharePointConfiguration
    ] = Optional.Absent,
    databaseConfiguration: Optional[
      zio.aws.kendra.model.DatabaseConfiguration
    ] = Optional.Absent,
    salesforceConfiguration: Optional[
      zio.aws.kendra.model.SalesforceConfiguration
    ] = Optional.Absent,
    oneDriveConfiguration: Optional[
      zio.aws.kendra.model.OneDriveConfiguration
    ] = Optional.Absent,
    serviceNowConfiguration: Optional[
      zio.aws.kendra.model.ServiceNowConfiguration
    ] = Optional.Absent,
    confluenceConfiguration: Optional[
      zio.aws.kendra.model.ConfluenceConfiguration
    ] = Optional.Absent,
    googleDriveConfiguration: Optional[
      zio.aws.kendra.model.GoogleDriveConfiguration
    ] = Optional.Absent,
    webCrawlerConfiguration: Optional[
      zio.aws.kendra.model.WebCrawlerConfiguration
    ] = Optional.Absent,
    workDocsConfiguration: Optional[
      zio.aws.kendra.model.WorkDocsConfiguration
    ] = Optional.Absent,
    fsxConfiguration: Optional[zio.aws.kendra.model.FsxConfiguration] =
      Optional.Absent,
    slackConfiguration: Optional[zio.aws.kendra.model.SlackConfiguration] =
      Optional.Absent,
    boxConfiguration: Optional[zio.aws.kendra.model.BoxConfiguration] =
      Optional.Absent,
    quipConfiguration: Optional[zio.aws.kendra.model.QuipConfiguration] =
      Optional.Absent,
    jiraConfiguration: Optional[zio.aws.kendra.model.JiraConfiguration] =
      Optional.Absent,
    gitHubConfiguration: Optional[zio.aws.kendra.model.GitHubConfiguration] =
      Optional.Absent,
    alfrescoConfiguration: Optional[
      zio.aws.kendra.model.AlfrescoConfiguration
    ] = Optional.Absent,
    templateConfiguration: Optional[
      zio.aws.kendra.model.TemplateConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DataSourceConfiguration = {
    import DataSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DataSourceConfiguration
      .builder()
      .optionallyWith(s3Configuration.map(value => value.buildAwsValue()))(
        _.s3Configuration
      )
      .optionallyWith(
        sharePointConfiguration.map(value => value.buildAwsValue())
      )(_.sharePointConfiguration)
      .optionallyWith(
        databaseConfiguration.map(value => value.buildAwsValue())
      )(_.databaseConfiguration)
      .optionallyWith(
        salesforceConfiguration.map(value => value.buildAwsValue())
      )(_.salesforceConfiguration)
      .optionallyWith(
        oneDriveConfiguration.map(value => value.buildAwsValue())
      )(_.oneDriveConfiguration)
      .optionallyWith(
        serviceNowConfiguration.map(value => value.buildAwsValue())
      )(_.serviceNowConfiguration)
      .optionallyWith(
        confluenceConfiguration.map(value => value.buildAwsValue())
      )(_.confluenceConfiguration)
      .optionallyWith(
        googleDriveConfiguration.map(value => value.buildAwsValue())
      )(_.googleDriveConfiguration)
      .optionallyWith(
        webCrawlerConfiguration.map(value => value.buildAwsValue())
      )(_.webCrawlerConfiguration)
      .optionallyWith(
        workDocsConfiguration.map(value => value.buildAwsValue())
      )(_.workDocsConfiguration)
      .optionallyWith(fsxConfiguration.map(value => value.buildAwsValue()))(
        _.fsxConfiguration
      )
      .optionallyWith(slackConfiguration.map(value => value.buildAwsValue()))(
        _.slackConfiguration
      )
      .optionallyWith(boxConfiguration.map(value => value.buildAwsValue()))(
        _.boxConfiguration
      )
      .optionallyWith(quipConfiguration.map(value => value.buildAwsValue()))(
        _.quipConfiguration
      )
      .optionallyWith(jiraConfiguration.map(value => value.buildAwsValue()))(
        _.jiraConfiguration
      )
      .optionallyWith(gitHubConfiguration.map(value => value.buildAwsValue()))(
        _.gitHubConfiguration
      )
      .optionallyWith(
        alfrescoConfiguration.map(value => value.buildAwsValue())
      )(_.alfrescoConfiguration)
      .optionallyWith(
        templateConfiguration.map(value => value.buildAwsValue())
      )(_.templateConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DataSourceConfiguration.ReadOnly =
    zio.aws.kendra.model.DataSourceConfiguration.wrap(buildAwsValue())
}
object DataSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DataSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DataSourceConfiguration =
      zio.aws.kendra.model.DataSourceConfiguration(
        s3Configuration.map(value => value.asEditable),
        sharePointConfiguration.map(value => value.asEditable),
        databaseConfiguration.map(value => value.asEditable),
        salesforceConfiguration.map(value => value.asEditable),
        oneDriveConfiguration.map(value => value.asEditable),
        serviceNowConfiguration.map(value => value.asEditable),
        confluenceConfiguration.map(value => value.asEditable),
        googleDriveConfiguration.map(value => value.asEditable),
        webCrawlerConfiguration.map(value => value.asEditable),
        workDocsConfiguration.map(value => value.asEditable),
        fsxConfiguration.map(value => value.asEditable),
        slackConfiguration.map(value => value.asEditable),
        boxConfiguration.map(value => value.asEditable),
        quipConfiguration.map(value => value.asEditable),
        jiraConfiguration.map(value => value.asEditable),
        gitHubConfiguration.map(value => value.asEditable),
        alfrescoConfiguration.map(value => value.asEditable),
        templateConfiguration.map(value => value.asEditable)
      )
    def s3Configuration
        : Optional[zio.aws.kendra.model.S3DataSourceConfiguration.ReadOnly]
    def sharePointConfiguration
        : Optional[zio.aws.kendra.model.SharePointConfiguration.ReadOnly]
    def databaseConfiguration
        : Optional[zio.aws.kendra.model.DatabaseConfiguration.ReadOnly]
    def salesforceConfiguration
        : Optional[zio.aws.kendra.model.SalesforceConfiguration.ReadOnly]
    def oneDriveConfiguration
        : Optional[zio.aws.kendra.model.OneDriveConfiguration.ReadOnly]
    def serviceNowConfiguration
        : Optional[zio.aws.kendra.model.ServiceNowConfiguration.ReadOnly]
    def confluenceConfiguration
        : Optional[zio.aws.kendra.model.ConfluenceConfiguration.ReadOnly]
    def googleDriveConfiguration
        : Optional[zio.aws.kendra.model.GoogleDriveConfiguration.ReadOnly]
    def webCrawlerConfiguration
        : Optional[zio.aws.kendra.model.WebCrawlerConfiguration.ReadOnly]
    def workDocsConfiguration
        : Optional[zio.aws.kendra.model.WorkDocsConfiguration.ReadOnly]
    def fsxConfiguration
        : Optional[zio.aws.kendra.model.FsxConfiguration.ReadOnly]
    def slackConfiguration
        : Optional[zio.aws.kendra.model.SlackConfiguration.ReadOnly]
    def boxConfiguration
        : Optional[zio.aws.kendra.model.BoxConfiguration.ReadOnly]
    def quipConfiguration
        : Optional[zio.aws.kendra.model.QuipConfiguration.ReadOnly]
    def jiraConfiguration
        : Optional[zio.aws.kendra.model.JiraConfiguration.ReadOnly]
    def gitHubConfiguration
        : Optional[zio.aws.kendra.model.GitHubConfiguration.ReadOnly]
    def alfrescoConfiguration
        : Optional[zio.aws.kendra.model.AlfrescoConfiguration.ReadOnly]
    def templateConfiguration
        : Optional[zio.aws.kendra.model.TemplateConfiguration.ReadOnly]
    def getS3Configuration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.S3DataSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3Configuration", s3Configuration)
    def getSharePointConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SharePointConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sharePointConfiguration",
      sharePointConfiguration
    )
    def getDatabaseConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DatabaseConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("databaseConfiguration", databaseConfiguration)
    def getSalesforceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SalesforceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "salesforceConfiguration",
      salesforceConfiguration
    )
    def getOneDriveConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.OneDriveConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("oneDriveConfiguration", oneDriveConfiguration)
    def getServiceNowConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ServiceNowConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceNowConfiguration",
      serviceNowConfiguration
    )
    def getConfluenceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ConfluenceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "confluenceConfiguration",
      confluenceConfiguration
    )
    def getGoogleDriveConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.GoogleDriveConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "googleDriveConfiguration",
      googleDriveConfiguration
    )
    def getWebCrawlerConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.WebCrawlerConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "webCrawlerConfiguration",
      webCrawlerConfiguration
    )
    def getWorkDocsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.WorkDocsConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("workDocsConfiguration", workDocsConfiguration)
    def getFsxConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.FsxConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("fsxConfiguration", fsxConfiguration)
    def getSlackConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.SlackConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("slackConfiguration", slackConfiguration)
    def getBoxConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.BoxConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("boxConfiguration", boxConfiguration)
    def getQuipConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.QuipConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("quipConfiguration", quipConfiguration)
    def getJiraConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.JiraConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("jiraConfiguration", jiraConfiguration)
    def getGitHubConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.GitHubConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("gitHubConfiguration", gitHubConfiguration)
    def getAlfrescoConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.AlfrescoConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("alfrescoConfiguration", alfrescoConfiguration)
    def getTemplateConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.TemplateConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("templateConfiguration", templateConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceConfiguration
  ) extends zio.aws.kendra.model.DataSourceConfiguration.ReadOnly {
    override val s3Configuration
        : Optional[zio.aws.kendra.model.S3DataSourceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Configuration())
        .map(value =>
          zio.aws.kendra.model.S3DataSourceConfiguration.wrap(value)
        )
    override val sharePointConfiguration
        : Optional[zio.aws.kendra.model.SharePointConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sharePointConfiguration())
        .map(value => zio.aws.kendra.model.SharePointConfiguration.wrap(value))
    override val databaseConfiguration
        : Optional[zio.aws.kendra.model.DatabaseConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseConfiguration())
        .map(value => zio.aws.kendra.model.DatabaseConfiguration.wrap(value))
    override val salesforceConfiguration
        : Optional[zio.aws.kendra.model.SalesforceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.salesforceConfiguration())
        .map(value => zio.aws.kendra.model.SalesforceConfiguration.wrap(value))
    override val oneDriveConfiguration
        : Optional[zio.aws.kendra.model.OneDriveConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oneDriveConfiguration())
        .map(value => zio.aws.kendra.model.OneDriveConfiguration.wrap(value))
    override val serviceNowConfiguration
        : Optional[zio.aws.kendra.model.ServiceNowConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceNowConfiguration())
        .map(value => zio.aws.kendra.model.ServiceNowConfiguration.wrap(value))
    override val confluenceConfiguration
        : Optional[zio.aws.kendra.model.ConfluenceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.confluenceConfiguration())
        .map(value => zio.aws.kendra.model.ConfluenceConfiguration.wrap(value))
    override val googleDriveConfiguration
        : Optional[zio.aws.kendra.model.GoogleDriveConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.googleDriveConfiguration())
        .map(value => zio.aws.kendra.model.GoogleDriveConfiguration.wrap(value))
    override val webCrawlerConfiguration
        : Optional[zio.aws.kendra.model.WebCrawlerConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.webCrawlerConfiguration())
        .map(value => zio.aws.kendra.model.WebCrawlerConfiguration.wrap(value))
    override val workDocsConfiguration
        : Optional[zio.aws.kendra.model.WorkDocsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workDocsConfiguration())
        .map(value => zio.aws.kendra.model.WorkDocsConfiguration.wrap(value))
    override val fsxConfiguration
        : Optional[zio.aws.kendra.model.FsxConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fsxConfiguration())
        .map(value => zio.aws.kendra.model.FsxConfiguration.wrap(value))
    override val slackConfiguration
        : Optional[zio.aws.kendra.model.SlackConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slackConfiguration())
        .map(value => zio.aws.kendra.model.SlackConfiguration.wrap(value))
    override val boxConfiguration
        : Optional[zio.aws.kendra.model.BoxConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.boxConfiguration())
        .map(value => zio.aws.kendra.model.BoxConfiguration.wrap(value))
    override val quipConfiguration
        : Optional[zio.aws.kendra.model.QuipConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quipConfiguration())
        .map(value => zio.aws.kendra.model.QuipConfiguration.wrap(value))
    override val jiraConfiguration
        : Optional[zio.aws.kendra.model.JiraConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jiraConfiguration())
        .map(value => zio.aws.kendra.model.JiraConfiguration.wrap(value))
    override val gitHubConfiguration
        : Optional[zio.aws.kendra.model.GitHubConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gitHubConfiguration())
        .map(value => zio.aws.kendra.model.GitHubConfiguration.wrap(value))
    override val alfrescoConfiguration
        : Optional[zio.aws.kendra.model.AlfrescoConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alfrescoConfiguration())
        .map(value => zio.aws.kendra.model.AlfrescoConfiguration.wrap(value))
    override val templateConfiguration
        : Optional[zio.aws.kendra.model.TemplateConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateConfiguration())
        .map(value => zio.aws.kendra.model.TemplateConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceConfiguration
  ): zio.aws.kendra.model.DataSourceConfiguration.ReadOnly = new Wrapper(impl)
}
