package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{DataSourceSyncJobId, DataSourceId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataSourceSyncJobMetricTarget(
    dataSourceId: DataSourceId,
    dataSourceSyncJobId: Optional[DataSourceSyncJobId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DataSourceSyncJobMetricTarget = {
    import DataSourceSyncJobMetricTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DataSourceSyncJobMetricTarget
      .builder()
      .dataSourceId(DataSourceId.unwrap(dataSourceId): java.lang.String)
      .optionallyWith(
        dataSourceSyncJobId.map(value =>
          DataSourceSyncJobId.unwrap(value): java.lang.String
        )
      )(_.dataSourceSyncJobId)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DataSourceSyncJobMetricTarget.ReadOnly =
    zio.aws.kendra.model.DataSourceSyncJobMetricTarget.wrap(buildAwsValue())
}
object DataSourceSyncJobMetricTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DataSourceSyncJobMetricTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DataSourceSyncJobMetricTarget =
      zio.aws.kendra.model.DataSourceSyncJobMetricTarget(
        dataSourceId,
        dataSourceSyncJobId.map(value => value)
      )
    def dataSourceId: DataSourceId
    def dataSourceSyncJobId: Optional[DataSourceSyncJobId]
    def getDataSourceId: ZIO[Any, Nothing, DataSourceId] =
      ZIO.succeed(dataSourceId)
    def getDataSourceSyncJobId: ZIO[Any, AwsError, DataSourceSyncJobId] =
      AwsError.unwrapOptionField("dataSourceSyncJobId", dataSourceSyncJobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceSyncJobMetricTarget
  ) extends zio.aws.kendra.model.DataSourceSyncJobMetricTarget.ReadOnly {
    override val dataSourceId: DataSourceId =
      zio.aws.kendra.model.primitives.DataSourceId(impl.dataSourceId())
    override val dataSourceSyncJobId: Optional[DataSourceSyncJobId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSourceSyncJobId())
        .map(value =>
          zio.aws.kendra.model.primitives.DataSourceSyncJobId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceSyncJobMetricTarget
  ): zio.aws.kendra.model.DataSourceSyncJobMetricTarget.ReadOnly = new Wrapper(
    impl
  )
}
