package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait DataSourceType {
  def unwrap: software.amazon.awssdk.services.kendra.model.DataSourceType
}
object DataSourceType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.DataSourceType
  ): zio.aws.kendra.model.DataSourceType = value match {
    case software.amazon.awssdk.services.kendra.model.DataSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.S3 =>
      val r = S3
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.SHAREPOINT =>
      val r = SHAREPOINT
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.DATABASE =>
      val r = DATABASE
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.SALESFORCE =>
      val r = SALESFORCE
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.ONEDRIVE =>
      val r = ONEDRIVE
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.SERVICENOW =>
      val r = SERVICENOW
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.CUSTOM =>
      val r = CUSTOM
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.CONFLUENCE =>
      val r = CONFLUENCE
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.GOOGLEDRIVE =>
      val r = GOOGLEDRIVE
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.WEBCRAWLER =>
      val r = WEBCRAWLER
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.WORKDOCS =>
      val r = WORKDOCS
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.FSX =>
      val r = FSX
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.SLACK =>
      val r = SLACK
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.BOX =>
      val r = BOX
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.QUIP =>
      val r = QUIP
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.JIRA =>
      val r = JIRA
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.GITHUB =>
      val r = GITHUB
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.ALFRESCO =>
      val r = ALFRESCO
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceType.TEMPLATE =>
      val r = TEMPLATE
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3 extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.S3
  }
  case object SHAREPOINT extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.SHAREPOINT
  }
  case object DATABASE extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.DATABASE
  }
  case object SALESFORCE extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.SALESFORCE
  }
  case object ONEDRIVE extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.ONEDRIVE
  }
  case object SERVICENOW extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.SERVICENOW
  }
  case object CUSTOM extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.CUSTOM
  }
  case object CONFLUENCE extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.CONFLUENCE
  }
  case object GOOGLEDRIVE extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.GOOGLEDRIVE
  }
  case object WEBCRAWLER extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.WEBCRAWLER
  }
  case object WORKDOCS extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.WORKDOCS
  }
  case object FSX extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.FSX
  }
  case object SLACK extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.SLACK
  }
  case object BOX extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.BOX
  }
  case object QUIP extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.QUIP
  }
  case object JIRA extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.JIRA
  }
  case object GITHUB extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.GITHUB
  }
  case object ALFRESCO extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.ALFRESCO
  }
  case object TEMPLATE extends zio.aws.kendra.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceType =
      software.amazon.awssdk.services.kendra.model.DataSourceType.TEMPLATE
  }
}
