package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DatabaseConfiguration(
    databaseEngineType: zio.aws.kendra.model.DatabaseEngineType,
    connectionConfiguration: zio.aws.kendra.model.ConnectionConfiguration,
    vpcConfiguration: Optional[
      zio.aws.kendra.model.DataSourceVpcConfiguration
    ] = Optional.Absent,
    columnConfiguration: zio.aws.kendra.model.ColumnConfiguration,
    aclConfiguration: Optional[zio.aws.kendra.model.AclConfiguration] =
      Optional.Absent,
    sqlConfiguration: Optional[zio.aws.kendra.model.SqlConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DatabaseConfiguration = {
    import DatabaseConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DatabaseConfiguration
      .builder()
      .databaseEngineType(databaseEngineType.unwrap)
      .connectionConfiguration(connectionConfiguration.buildAwsValue())
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .columnConfiguration(columnConfiguration.buildAwsValue())
      .optionallyWith(aclConfiguration.map(value => value.buildAwsValue()))(
        _.aclConfiguration
      )
      .optionallyWith(sqlConfiguration.map(value => value.buildAwsValue()))(
        _.sqlConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DatabaseConfiguration.ReadOnly =
    zio.aws.kendra.model.DatabaseConfiguration.wrap(buildAwsValue())
}
object DatabaseConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DatabaseConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DatabaseConfiguration =
      zio.aws.kendra.model.DatabaseConfiguration(
        databaseEngineType,
        connectionConfiguration.asEditable,
        vpcConfiguration.map(value => value.asEditable),
        columnConfiguration.asEditable,
        aclConfiguration.map(value => value.asEditable),
        sqlConfiguration.map(value => value.asEditable)
      )
    def databaseEngineType: zio.aws.kendra.model.DatabaseEngineType
    def connectionConfiguration
        : zio.aws.kendra.model.ConnectionConfiguration.ReadOnly
    def vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly]
    def columnConfiguration: zio.aws.kendra.model.ColumnConfiguration.ReadOnly
    def aclConfiguration
        : Optional[zio.aws.kendra.model.AclConfiguration.ReadOnly]
    def sqlConfiguration
        : Optional[zio.aws.kendra.model.SqlConfiguration.ReadOnly]
    def getDatabaseEngineType
        : ZIO[Any, Nothing, zio.aws.kendra.model.DatabaseEngineType] =
      ZIO.succeed(databaseEngineType)
    def getConnectionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.kendra.model.ConnectionConfiguration.ReadOnly
    ] = ZIO.succeed(connectionConfiguration)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getColumnConfiguration
        : ZIO[Any, Nothing, zio.aws.kendra.model.ColumnConfiguration.ReadOnly] =
      ZIO.succeed(columnConfiguration)
    def getAclConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.AclConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("aclConfiguration", aclConfiguration)
    def getSqlConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.SqlConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("sqlConfiguration", sqlConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DatabaseConfiguration
  ) extends zio.aws.kendra.model.DatabaseConfiguration.ReadOnly {
    override val databaseEngineType: zio.aws.kendra.model.DatabaseEngineType =
      zio.aws.kendra.model.DatabaseEngineType.wrap(impl.databaseEngineType())
    override val connectionConfiguration
        : zio.aws.kendra.model.ConnectionConfiguration.ReadOnly =
      zio.aws.kendra.model.ConnectionConfiguration
        .wrap(impl.connectionConfiguration())
    override val vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value =>
          zio.aws.kendra.model.DataSourceVpcConfiguration.wrap(value)
        )
    override val columnConfiguration
        : zio.aws.kendra.model.ColumnConfiguration.ReadOnly =
      zio.aws.kendra.model.ColumnConfiguration.wrap(impl.columnConfiguration())
    override val aclConfiguration
        : Optional[zio.aws.kendra.model.AclConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aclConfiguration())
        .map(value => zio.aws.kendra.model.AclConfiguration.wrap(value))
    override val sqlConfiguration
        : Optional[zio.aws.kendra.model.SqlConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sqlConfiguration())
        .map(value => zio.aws.kendra.model.SqlConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DatabaseConfiguration
  ): zio.aws.kendra.model.DatabaseConfiguration.ReadOnly = new Wrapper(impl)
}
