package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{QuerySuggestionsBlockListId, IndexId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteQuerySuggestionsBlockListRequest(
    indexId: IndexId,
    id: QuerySuggestionsBlockListId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DeleteQuerySuggestionsBlockListRequest = {
    import DeleteQuerySuggestionsBlockListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DeleteQuerySuggestionsBlockListRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .id(QuerySuggestionsBlockListId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DeleteQuerySuggestionsBlockListRequest.ReadOnly =
    zio.aws.kendra.model.DeleteQuerySuggestionsBlockListRequest
      .wrap(buildAwsValue())
}
object DeleteQuerySuggestionsBlockListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DeleteQuerySuggestionsBlockListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.DeleteQuerySuggestionsBlockListRequest =
      zio.aws.kendra.model.DeleteQuerySuggestionsBlockListRequest(indexId, id)
    def indexId: IndexId
    def id: QuerySuggestionsBlockListId
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getId: ZIO[Any, Nothing, QuerySuggestionsBlockListId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DeleteQuerySuggestionsBlockListRequest
  ) extends zio.aws.kendra.model.DeleteQuerySuggestionsBlockListRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val id: QuerySuggestionsBlockListId =
      zio.aws.kendra.model.primitives.QuerySuggestionsBlockListId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DeleteQuerySuggestionsBlockListRequest
  ): zio.aws.kendra.model.DeleteQuerySuggestionsBlockListRequest.ReadOnly =
    new Wrapper(impl)
}
