package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ErrorMessage,
  Description,
  AccessControlConfigurationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeAccessControlConfigurationResponse(
    name: AccessControlConfigurationName,
    description: Optional[Description] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    accessControlList: Optional[Iterable[zio.aws.kendra.model.Principal]] =
      Optional.Absent,
    hierarchicalAccessControlList: Optional[
      Iterable[zio.aws.kendra.model.HierarchicalPrincipal]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationResponse = {
    import DescribeAccessControlConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationResponse
      .builder()
      .name(AccessControlConfigurationName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        accessControlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessControlList)
      .optionallyWith(
        hierarchicalAccessControlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hierarchicalAccessControlList)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DescribeAccessControlConfigurationResponse.ReadOnly =
    zio.aws.kendra.model.DescribeAccessControlConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeAccessControlConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.DescribeAccessControlConfigurationResponse =
      zio.aws.kendra.model.DescribeAccessControlConfigurationResponse(
        name,
        description.map(value => value),
        errorMessage.map(value => value),
        accessControlList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hierarchicalAccessControlList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: AccessControlConfigurationName
    def description: Optional[Description]
    def errorMessage: Optional[ErrorMessage]
    def accessControlList
        : Optional[List[zio.aws.kendra.model.Principal.ReadOnly]]
    def hierarchicalAccessControlList
        : Optional[List[zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly]]
    def getName: ZIO[Any, Nothing, AccessControlConfigurationName] =
      ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getAccessControlList
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Principal.ReadOnly]] =
      AwsError.unwrapOptionField("accessControlList", accessControlList)
    def getHierarchicalAccessControlList: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "hierarchicalAccessControlList",
      hierarchicalAccessControlList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationResponse
  ) extends zio.aws.kendra.model.DescribeAccessControlConfigurationResponse.ReadOnly {
    override val name: AccessControlConfigurationName =
      zio.aws.kendra.model.primitives
        .AccessControlConfigurationName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
    override val accessControlList
        : Optional[List[zio.aws.kendra.model.Principal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessControlList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Principal.wrap(item)
          }.toList
        )
    override val hierarchicalAccessControlList
        : Optional[List[zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hierarchicalAccessControlList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.HierarchicalPrincipal.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationResponse
  ): zio.aws.kendra.model.DescribeAccessControlConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
