package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{IndexId, ExperienceId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeExperienceRequest(id: ExperienceId, indexId: IndexId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeExperienceRequest = {
    import DescribeExperienceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeExperienceRequest
      .builder()
      .id(ExperienceId.unwrap(id): java.lang.String)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DescribeExperienceRequest.ReadOnly =
    zio.aws.kendra.model.DescribeExperienceRequest.wrap(buildAwsValue())
}
object DescribeExperienceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeExperienceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeExperienceRequest =
      zio.aws.kendra.model.DescribeExperienceRequest(id, indexId)
    def id: ExperienceId
    def indexId: IndexId
    def getId: ZIO[Any, Nothing, ExperienceId] = ZIO.succeed(id)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeExperienceRequest
  ) extends zio.aws.kendra.model.DescribeExperienceRequest.ReadOnly {
    override val id: ExperienceId =
      zio.aws.kendra.model.primitives.ExperienceId(impl.id())
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeExperienceRequest
  ): zio.aws.kendra.model.DescribeExperienceRequest.ReadOnly = new Wrapper(impl)
}
