package zio.aws.kendra.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  ExperienceName,
  ExperienceId,
  ErrorMessage,
  RoleArn,
  Timestamp,
  IndexId,
  Description
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeExperienceResponse(
    id: Optional[ExperienceId] = Optional.Absent,
    indexId: Optional[IndexId] = Optional.Absent,
    name: Optional[ExperienceName] = Optional.Absent,
    endpoints: Optional[Iterable[zio.aws.kendra.model.ExperienceEndpoint]] =
      Optional.Absent,
    configuration: Optional[zio.aws.kendra.model.ExperienceConfiguration] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    status: Optional[zio.aws.kendra.model.ExperienceStatus] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeExperienceResponse = {
    import DescribeExperienceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeExperienceResponse
      .builder()
      .optionallyWith(
        id.map(value => ExperienceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        indexId.map(value => IndexId.unwrap(value): java.lang.String)
      )(_.indexId)
      .optionallyWith(
        name.map(value => ExperienceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpoints)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DescribeExperienceResponse.ReadOnly =
    zio.aws.kendra.model.DescribeExperienceResponse.wrap(buildAwsValue())
}
object DescribeExperienceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeExperienceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeExperienceResponse =
      zio.aws.kendra.model.DescribeExperienceResponse(
        id.map(value => value),
        indexId.map(value => value),
        name.map(value => value),
        endpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configuration.map(value => value.asEditable),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        description.map(value => value),
        status.map(value => value),
        roleArn.map(value => value),
        errorMessage.map(value => value)
      )
    def id: Optional[ExperienceId]
    def indexId: Optional[IndexId]
    def name: Optional[ExperienceName]
    def endpoints
        : Optional[List[zio.aws.kendra.model.ExperienceEndpoint.ReadOnly]]
    def configuration
        : Optional[zio.aws.kendra.model.ExperienceConfiguration.ReadOnly]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def description: Optional[Description]
    def status: Optional[zio.aws.kendra.model.ExperienceStatus]
    def roleArn: Optional[RoleArn]
    def errorMessage: Optional[ErrorMessage]
    def getId: ZIO[Any, AwsError, ExperienceId] =
      AwsError.unwrapOptionField("id", id)
    def getIndexId: ZIO[Any, AwsError, IndexId] =
      AwsError.unwrapOptionField("indexId", indexId)
    def getName: ZIO[Any, AwsError, ExperienceName] =
      AwsError.unwrapOptionField("name", name)
    def getEndpoints: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.ExperienceEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("endpoints", endpoints)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ExperienceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.ExperienceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeExperienceResponse
  ) extends zio.aws.kendra.model.DescribeExperienceResponse.ReadOnly {
    override val id: Optional[ExperienceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ExperienceId(value))
    override val indexId: Optional[IndexId] = zio.aws.core.internal
      .optionalFromNullable(impl.indexId())
      .map(value => zio.aws.kendra.model.primitives.IndexId(value))
    override val name: Optional[ExperienceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.kendra.model.primitives.ExperienceName(value))
    override val endpoints
        : Optional[List[zio.aws.kendra.model.ExperienceEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.ExperienceEndpoint.wrap(item)
          }.toList
        )
    override val configuration
        : Optional[zio.aws.kendra.model.ExperienceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value => zio.aws.kendra.model.ExperienceConfiguration.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val status: Optional[zio.aws.kendra.model.ExperienceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kendra.model.ExperienceStatus.wrap(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeExperienceResponse
  ): zio.aws.kendra.model.DescribeExperienceResponse.ReadOnly = new Wrapper(
    impl
  )
}
