package zio.aws.kendra.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  ErrorMessage,
  RoleArn,
  FaqId,
  LanguageCode,
  FaqName,
  Timestamp,
  IndexId,
  Description
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeFaqResponse(
    id: Optional[FaqId] = Optional.Absent,
    indexId: Optional[IndexId] = Optional.Absent,
    name: Optional[FaqName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    s3Path: Optional[zio.aws.kendra.model.S3Path] = Optional.Absent,
    status: Optional[zio.aws.kendra.model.FaqStatus] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    fileFormat: Optional[zio.aws.kendra.model.FaqFileFormat] = Optional.Absent,
    languageCode: Optional[LanguageCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeFaqResponse = {
    import DescribeFaqResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeFaqResponse
      .builder()
      .optionallyWith(id.map(value => FaqId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        indexId.map(value => IndexId.unwrap(value): java.lang.String)
      )(_.indexId)
      .optionallyWith(
        name.map(value => FaqName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(s3Path.map(value => value.buildAwsValue()))(_.s3Path)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(fileFormat.map(value => value.unwrap))(_.fileFormat)
      .optionallyWith(
        languageCode.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.languageCode)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DescribeFaqResponse.ReadOnly =
    zio.aws.kendra.model.DescribeFaqResponse.wrap(buildAwsValue())
}
object DescribeFaqResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeFaqResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeFaqResponse =
      zio.aws.kendra.model.DescribeFaqResponse(
        id.map(value => value),
        indexId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        s3Path.map(value => value.asEditable),
        status.map(value => value),
        roleArn.map(value => value),
        errorMessage.map(value => value),
        fileFormat.map(value => value),
        languageCode.map(value => value)
      )
    def id: Optional[FaqId]
    def indexId: Optional[IndexId]
    def name: Optional[FaqName]
    def description: Optional[Description]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def s3Path: Optional[zio.aws.kendra.model.S3Path.ReadOnly]
    def status: Optional[zio.aws.kendra.model.FaqStatus]
    def roleArn: Optional[RoleArn]
    def errorMessage: Optional[ErrorMessage]
    def fileFormat: Optional[zio.aws.kendra.model.FaqFileFormat]
    def languageCode: Optional[LanguageCode]
    def getId: ZIO[Any, AwsError, FaqId] = AwsError.unwrapOptionField("id", id)
    def getIndexId: ZIO[Any, AwsError, IndexId] =
      AwsError.unwrapOptionField("indexId", indexId)
    def getName: ZIO[Any, AwsError, FaqName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getS3Path: ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("s3Path", s3Path)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.FaqStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getFileFormat: ZIO[Any, AwsError, zio.aws.kendra.model.FaqFileFormat] =
      AwsError.unwrapOptionField("fileFormat", fileFormat)
    def getLanguageCode: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeFaqResponse
  ) extends zio.aws.kendra.model.DescribeFaqResponse.ReadOnly {
    override val id: Optional[FaqId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.FaqId(value))
    override val indexId: Optional[IndexId] = zio.aws.core.internal
      .optionalFromNullable(impl.indexId())
      .map(value => zio.aws.kendra.model.primitives.IndexId(value))
    override val name: Optional[FaqName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.kendra.model.primitives.FaqName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val s3Path: Optional[zio.aws.kendra.model.S3Path.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Path())
        .map(value => zio.aws.kendra.model.S3Path.wrap(value))
    override val status: Optional[zio.aws.kendra.model.FaqStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kendra.model.FaqStatus.wrap(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
    override val fileFormat: Optional[zio.aws.kendra.model.FaqFileFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileFormat())
        .map(value => zio.aws.kendra.model.FaqFileFormat.wrap(value))
    override val languageCode: Optional[LanguageCode] = zio.aws.core.internal
      .optionalFromNullable(impl.languageCode())
      .map(value => zio.aws.kendra.model.primitives.LanguageCode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeFaqResponse
  ): zio.aws.kendra.model.DescribeFaqResponse.ReadOnly = new Wrapper(impl)
}
