package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{FeaturedResultsSetId, IndexId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeFeaturedResultsSetRequest(
    indexId: IndexId,
    featuredResultsSetId: FeaturedResultsSetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeFeaturedResultsSetRequest = {
    import DescribeFeaturedResultsSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeFeaturedResultsSetRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .featuredResultsSetId(
        FeaturedResultsSetId.unwrap(featuredResultsSetId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DescribeFeaturedResultsSetRequest.ReadOnly =
    zio.aws.kendra.model.DescribeFeaturedResultsSetRequest.wrap(buildAwsValue())
}
object DescribeFeaturedResultsSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeFeaturedResultsSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeFeaturedResultsSetRequest =
      zio.aws.kendra.model
        .DescribeFeaturedResultsSetRequest(indexId, featuredResultsSetId)
    def indexId: IndexId
    def featuredResultsSetId: FeaturedResultsSetId
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getFeaturedResultsSetId: ZIO[Any, Nothing, FeaturedResultsSetId] =
      ZIO.succeed(featuredResultsSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeFeaturedResultsSetRequest
  ) extends zio.aws.kendra.model.DescribeFeaturedResultsSetRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val featuredResultsSetId: FeaturedResultsSetId =
      zio.aws.kendra.model.primitives
        .FeaturedResultsSetId(impl.featuredResultsSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeFeaturedResultsSetRequest
  ): zio.aws.kendra.model.DescribeFeaturedResultsSetRequest.ReadOnly =
    new Wrapper(impl)
}
