package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{GroupId, DataSourceId, IndexId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribePrincipalMappingRequest(
    indexId: IndexId,
    dataSourceId: Optional[DataSourceId] = Optional.Absent,
    groupId: GroupId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingRequest = {
    import DescribePrincipalMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        dataSourceId.map(value => DataSourceId.unwrap(value): java.lang.String)
      )(_.dataSourceId)
      .groupId(GroupId.unwrap(groupId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DescribePrincipalMappingRequest.ReadOnly =
    zio.aws.kendra.model.DescribePrincipalMappingRequest.wrap(buildAwsValue())
}
object DescribePrincipalMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribePrincipalMappingRequest =
      zio.aws.kendra.model.DescribePrincipalMappingRequest(
        indexId,
        dataSourceId.map(value => value),
        groupId
      )
    def indexId: IndexId
    def dataSourceId: Optional[DataSourceId]
    def groupId: GroupId
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getDataSourceId: ZIO[Any, AwsError, DataSourceId] =
      AwsError.unwrapOptionField("dataSourceId", dataSourceId)
    def getGroupId: ZIO[Any, Nothing, GroupId] = ZIO.succeed(groupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingRequest
  ) extends zio.aws.kendra.model.DescribePrincipalMappingRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val dataSourceId: Optional[DataSourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceId())
      .map(value => zio.aws.kendra.model.primitives.DataSourceId(value))
    override val groupId: GroupId =
      zio.aws.kendra.model.primitives.GroupId(impl.groupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingRequest
  ): zio.aws.kendra.model.DescribePrincipalMappingRequest.ReadOnly =
    new Wrapper(impl)
}
