package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{QuerySuggestionsBlockListId, IndexId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeQuerySuggestionsBlockListRequest(
    indexId: IndexId,
    id: QuerySuggestionsBlockListId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListRequest = {
    import DescribeQuerySuggestionsBlockListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .id(QuerySuggestionsBlockListId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DescribeQuerySuggestionsBlockListRequest.ReadOnly =
    zio.aws.kendra.model.DescribeQuerySuggestionsBlockListRequest
      .wrap(buildAwsValue())
}
object DescribeQuerySuggestionsBlockListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.DescribeQuerySuggestionsBlockListRequest =
      zio.aws.kendra.model.DescribeQuerySuggestionsBlockListRequest(indexId, id)
    def indexId: IndexId
    def id: QuerySuggestionsBlockListId
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getId: ZIO[Any, Nothing, QuerySuggestionsBlockListId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListRequest
  ) extends zio.aws.kendra.model.DescribeQuerySuggestionsBlockListRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val id: QuerySuggestionsBlockListId =
      zio.aws.kendra.model.primitives.QuerySuggestionsBlockListId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListRequest
  ): zio.aws.kendra.model.DescribeQuerySuggestionsBlockListRequest.ReadOnly =
    new Wrapper(impl)
}
