package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.IndexId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeQuerySuggestionsConfigRequest(indexId: IndexId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigRequest = {
    import DescribeQuerySuggestionsConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DescribeQuerySuggestionsConfigRequest.ReadOnly =
    zio.aws.kendra.model.DescribeQuerySuggestionsConfigRequest
      .wrap(buildAwsValue())
}
object DescribeQuerySuggestionsConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeQuerySuggestionsConfigRequest =
      zio.aws.kendra.model.DescribeQuerySuggestionsConfigRequest(indexId)
    def indexId: IndexId
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigRequest
  ) extends zio.aws.kendra.model.DescribeQuerySuggestionsConfigRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigRequest
  ): zio.aws.kendra.model.DescribeQuerySuggestionsConfigRequest.ReadOnly =
    new Wrapper(impl)
}
